/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.CropBasicGrowthCraft;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableBasicGrowthCraft
implements IFarmable {
    private final Block block;
    private final int matureMeta;
    private final boolean isRice;
    private final boolean isGrape;

    public FarmableBasicGrowthCraft(Block block, int matureMeta, boolean isRice, boolean isGrape) {
        this.block = block;
        this.matureMeta = matureMeta;
        this.isRice = isRice;
        this.isGrape = isGrape;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this.block;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != this.block) {
            return null;
        }
        if (block.func_176201_c(blockState) != this.matureMeta) {
            return null;
        }
        return new CropBasicGrowthCraft(world, this.block, this.matureMeta, pos, this.isRice, this.isGrape);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStackUtil.equals(this.block, itemstack);
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return world.func_180501_a(pos, this.block.func_176223_P(), 2);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

