/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockSoil;
import forestry.farming.logic.CropPeat;
import forestry.farming.logic.FarmLogicWatered;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FarmLogicPeat
extends FarmLogicWatered {
    private static final ItemStack bogEarth = PluginCore.blocks.soil.get(BlockSoil.SoilType.BOG_EARTH, 1);

    public FarmLogicPeat(IFarmHousing housing) {
        super(housing, bogEarth, bogEarth);
    }

    @Override
    public boolean isAcceptedGround(ItemStack itemStack) {
        if (super.isAcceptedGround(itemStack)) {
            return true;
        }
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (!(block instanceof BlockSoil)) {
            return false;
        }
        BlockSoil blockSoil = (BlockSoil)block;
        BlockSoil.SoilType soilType = BlockSoil.getTypeFromMeta(itemStack.func_77952_i());
        return soilType == BlockSoil.SoilType.BOG_EARTH || soilType == BlockSoil.SoilType.PEAT;
    }

    @Override
    public int getFertilizerConsumption() {
        return 2;
    }

    @Override
    public String getName() {
        if (this.isManual) {
            return "Manual Peat Bog";
        }
        return "Managed Peat Bog";
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockSoil.SoilType soilType;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState blockState = world.func_180495_p(position);
            Block block = blockState.func_177230_c();
            if (!(block instanceof BlockSoil) || (soilType = BlockSoil.getTypeFromState(blockState)) != BlockSoil.SoilType.PEAT) continue;
            crops.push(new CropPeat(world, position));
        }
        return crops;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item getItem() {
        return PluginCore.items.peat;
    }
}

