/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.FarmHelper;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FarmLogicHomogeneous
extends FarmLogic {
    private final ItemStack resource;
    private final ItemStack soilBlock;
    protected final List<IFarmable> germlings;
    List<ItemStack> produce = new ArrayList<ItemStack>();

    protected FarmLogicHomogeneous(IFarmHousing housing, ItemStack resource, ItemStack soilBlock, Iterable<IFarmable> germlings) {
        super(housing);
        this.resource = resource;
        this.soilBlock = soilBlock;
        this.germlings = new ArrayList<IFarmable>();
        for (IFarmable germling : germlings) {
            this.germlings.add(germling);
        }
    }

    protected boolean isAcceptedSoil(ItemStack itemStack) {
        return ItemStackUtil.isIdenticalItem(this.soilBlock, itemStack);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource.func_77969_a(itemstack);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.germlings) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(BlockPos pos, FarmDirection direction, int extent) {
        if (this.maintainSoil(pos, direction, extent)) {
            return true;
        }
        return this.maintainGermlings(pos.func_177982_a(0, 1, 0), direction, extent);
    }

    private boolean maintainSoil(BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position;
        IBlockState blockState1;
        Block soil;
        ItemStack[] resources = new ItemStack[]{this.resource};
        if (!this.housing.getFarmInventory().hasResources(resources)) {
            return false;
        }
        World world = this.getWorld();
        for (int i = 0; i < extent && !FarmHelper.bricks.contains((Object)(soil = (blockState1 = world.func_180495_p(position = this.translateWithOffset(pos, direction, i))).func_177230_c())); ++i) {
            IBlockState soilState = world.func_180495_p(position);
            Block soilBlock = soilState.func_177230_c();
            ItemStack soilStack = soilBlock.getPickBlock(soilState, null, world, position, null);
            if (this.isAcceptedSoil(soilStack)) continue;
            BlockPos platformPosition = position.func_177977_b();
            IBlockState blockState = world.func_180495_p(platformPosition);
            Block platformBlock = blockState.func_177230_c();
            if (!FarmHelper.bricks.contains((Object)platformBlock)) break;
            this.produce.addAll(BlockUtil.getBlockDrops(world, position));
            this.setBlock(position, ItemStackUtil.getBlock(this.soilBlock), this.soilBlock.func_77952_i());
            this.housing.getFarmInventory().removeResources(resources);
            return true;
        }
        return false;
    }

    protected abstract boolean maintainGermlings(BlockPos var1, FarmDirection var2, int var3);
}

