/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.FarmLogic;
import java.util.Collection;
import java.util.Stack;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FarmLogicGourd
extends FarmLogic {
    private final IFarmable[] seeds;

    public FarmLogicGourd(IFarmHousing housing) {
        super(housing);
        Collection<IFarmable> farmables = Farmables.farmables.get("farmGourd");
        this.seeds = farmables.toArray(new IFarmable[farmables.size()]);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item getItem() {
        return Items.field_151127_ba;
    }

    @Override
    public String getName() {
        return "Gourd Farm";
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(40.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        Stack<ICrop> crops = new Stack<ICrop>();
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos.func_177982_a(0, 1, 0), direction, i);
            for (IFarmable seed : this.seeds) {
                ICrop crop = seed.getCropAt(world, position);
                if (crop == null) continue;
                crops.push(crop);
            }
        }
        return crops;
    }
}

