/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.google.common.collect.Maps;
import forestry.api.arboriculture.EnumWoodType;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
class WoodTypeStateMapper
extends StateMapperBase {
    @Nonnull
    private final IWoodTyped woodTyped;
    @Nonnull
    private final String blockPath;
    @Nullable
    private final PropertyWoodType propertyWoodType;
    @Nonnull
    private final List<IProperty> propertiesToRemove = new ArrayList<IProperty>();

    public WoodTypeStateMapper(@Nonnull IWoodTyped woodTyped, @Nullable PropertyWoodType propertyWoodType) {
        this.woodTyped = woodTyped;
        this.blockPath = woodTyped.getBlockKind();
        this.propertyWoodType = propertyWoodType;
    }

    public WoodTypeStateMapper(@Nonnull IWoodTyped woodTyped, @Nonnull String blockPath, @Nullable PropertyWoodType propertyWoodType) {
        this.woodTyped = woodTyped;
        this.blockPath = blockPath;
        this.propertyWoodType = propertyWoodType;
    }

    public WoodTypeStateMapper addPropertyToRemove(IProperty property) {
        this.propertiesToRemove.add(property);
        return this;
    }

    protected ModelResourceLocation func_178132_a(IBlockState state) {
        LinkedHashMap properties;
        if (this.propertyWoodType != null) {
            properties = Maps.newLinkedHashMap((Map)state.func_177228_b());
            properties.remove((Object)this.propertyWoodType);
        } else {
            properties = Maps.newLinkedHashMap((Map)state.func_177228_b());
        }
        for (IProperty property : this.propertiesToRemove) {
            properties.remove(property);
        }
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        EnumWoodType woodType = this.woodTyped.getWoodType(meta);
        String resourceDomain = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)block)).func_110624_b();
        String resourceLocation = "arboriculture/" + this.blockPath + '/' + (Object)((Object)woodType);
        String propertyString = this.func_178131_a(properties);
        return new ModelResourceLocation(resourceDomain + ':' + resourceLocation, propertyString);
    }
}

