/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.WoodHelper;
import forestry.arboriculture.blocks.WoodTypeStateMapper;
import forestry.arboriculture.blocks.property.PropertyWoodType;
import forestry.core.proxy.Proxies;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockArbPlanks
extends Block
implements IWoodTyped,
IStateMapperRegister,
IItemModelRegister {
    private static final int VARIANTS_PER_BLOCK = 16;
    private static final int VARIANTS_META_MASK = 15;
    private final boolean fireproof;
    private final int blockNumber;

    public static List<BlockArbPlanks> create(boolean fireproof) {
        ArrayList<BlockArbPlanks> planks = new ArrayList<BlockArbPlanks>();
        int blockCount = PropertyWoodType.getBlockCount(16);
        for (int blockNumber = 0; blockNumber < blockCount; ++blockNumber) {
            final PropertyWoodType variant = PropertyWoodType.create("variant", blockNumber, 16);
            BlockArbPlanks block = new BlockArbPlanks(fireproof, blockNumber){

                @Override
                @Nonnull
                public PropertyWoodType getVariant() {
                    return variant;
                }
            };
            planks.add(block);
        }
        return planks;
    }

    private BlockArbPlanks(boolean fireproof, int blockNumber) {
        super(Material.field_151575_d);
        this.fireproof = fireproof;
        this.blockNumber = blockNumber;
        PropertyWoodType variant = this.getVariant();
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)variant, (Comparable)((Object)variant.getFirstType())));
        this.func_149752_b(5.0f);
        this.setHarvestLevel("axe", 0);
    }

    @Override
    public boolean isFireproof() {
        return this.fireproof;
    }

    @Nonnull
    public abstract PropertyWoodType getVariant();

    public int getBlockNumber() {
        return this.blockNumber;
    }

    @Override
    @Nonnull
    public String getBlockKind() {
        return "planks";
    }

    public IBlockState func_176203_a(int meta) {
        EnumWoodType woodType = this.getWoodType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)woodType));
    }

    @Override
    @Nonnull
    public EnumWoodType getWoodType(int meta) {
        int variantMeta = (meta & 0xF) + this.blockNumber * 16;
        return EnumWoodType.byMetadata(variantMeta);
    }

    @Override
    @Nonnull
    public Collection<EnumWoodType> getWoodTypes() {
        return this.getVariant().func_177700_c();
    }

    public int func_176201_c(IBlockState state) {
        return this.func_180651_a(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.getVariant()});
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumWoodType)((Object)state.func_177229_b((IProperty)this.getVariant()))).getMetadata() - this.blockNumber * 16;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumWoodType woodType = this.getWoodType(meta);
        return this.func_176223_P().func_177226_a((IProperty)this.getVariant(), (Comparable)((Object)woodType));
    }

    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        for (EnumWoodType woodType : this.getVariant().func_177700_c()) {
            list.add(TreeManager.woodAccess.getPlanks(woodType, this.fireproof));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerStateMapper() {
        Proxies.render.registerStateMapper(this, (IStateMapper)new WoodTypeStateMapper(this, this.getVariant()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerVariant(item, WoodHelper.getResourceLocations(this));
        manager.registerItemModel(item, new WoodHelper.WoodMeshDefinition(this));
    }

    public float func_176195_g(IBlockState blockState, World worldIn, BlockPos pos) {
        int meta = this.func_176201_c(blockState);
        EnumWoodType woodType = this.getWoodType(meta);
        return woodType.getHardness();
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 20;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        if (this.fireproof) {
            return 0;
        }
        return 5;
    }
}

