/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins.compat;

import forestry.api.apiculture.FlowerManager;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.Farmables;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.core.PluginCore;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.logic.FarmableBasicFruit;
import forestry.farming.logic.FarmableGenericCrop;
import forestry.farming.logic.FarmableGenericSapling;
import forestry.plugins.BlankForestryPlugin;
import forestry.plugins.ForestryPlugin;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ForestryPlugin(pluginID="forestry.biomes.o.plenty", name="BiomesOPlenty", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.plugin.biomesoplenty.description")
public class PluginBiomesOPlenty
extends BlankForestryPlugin {
    private static final String BoP = "BiomesOPlenty";
    private static Block saplings;
    private static Block colorizedSaplings;
    private static Item food;
    private static Item misc;
    private static ItemStack persimmon;
    private static int amount;

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(BoP);
    }

    @Override
    public String getFailMessage() {
        return "BiomesOPlenty not found";
    }

    @Override
    public void doInit() {
        super.doInit();
        saplings = GameRegistry.findBlock((String)BoP, (String)"saplings");
        colorizedSaplings = GameRegistry.findBlock((String)BoP, (String)"colorizedSaplings");
        food = GameRegistry.findItem((String)BoP, (String)"food");
        if (food != null) {
            persimmon = new ItemStack(food, 1, 8);
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.apiculture")) {
            PluginBiomesOPlenty.addFlowers();
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.farming")) {
            PluginBiomesOPlenty.addFarmCrops();
        }
    }

    @Override
    public void registerRecipes() {
        super.registerRecipes();
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
            PluginBiomesOPlenty.addFermenterRecipes();
            PluginBiomesOPlenty.addSqueezerRecipes();
        }
    }

    private static void addFarmCrops() {
        ArrayList<String> saplingItemKeys = new ArrayList<String>();
        if (saplings != null) {
            saplingItemKeys.add("saplings");
        }
        if (colorizedSaplings != null) {
            saplingItemKeys.add("colorizedSaplings");
        }
        for (String key : saplingItemKeys) {
            Item saplingItem = GameRegistry.findItem((String)BoP, (String)key);
            String saplingName = ItemStackUtil.getItemNameFromRegistryAsString(saplingItem);
            if (saplingName == null) continue;
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        }
        if (ForestryAPI.enabledPlugins.contains("forestry.farming") && saplings != null && persimmon != null) {
            Farmables.farmables.get("farmArboreal").add(new FarmableGenericSapling(saplings, 15, persimmon));
        }
        Block boPTurnip = GameRegistry.findBlock((String)BoP, (String)"turnip");
        if (ForestryAPI.enabledPlugins.contains("forestry.farming") && boPTurnip != null) {
            Item boPTurnipSeeds = GameRegistry.findItem((String)BoP, (String)"turnipSeeds");
            ItemStack boPTurnipSeedStack = new ItemStack(boPTurnipSeeds, 1, 0);
            if (boPTurnipSeeds != null) {
                Farmables.farmables.get("farmVegetables").add(new FarmableGenericCrop(boPTurnipSeedStack, boPTurnip, 7, new ItemStack[0]));
                if (ForestryAPI.enabledPlugins.contains("forestry.factory")) {
                    RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{boPTurnipSeedStack}, Fluids.SEED_OIL.getFluid(amount));
                }
            }
            Farmables.farmables.get("farmOrchard").add(new FarmableBasicFruit(boPTurnip, 7));
        }
    }

    private static void addFermenterRecipes() {
        int saplingYield = ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling");
        if (saplings != null) {
            RecipeUtil.addFermenterRecipes(new ItemStack(saplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
        if (colorizedSaplings != null) {
            RecipeUtil.addFermenterRecipes(new ItemStack(colorizedSaplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
    }

    private static void addSqueezerRecipes() {
        ItemStack pinecone;
        ItemStack mulch = new ItemStack((Item)PluginCore.items.mulch);
        misc = GameRegistry.findItem((String)BoP, (String)"misc");
        if (misc != null && (pinecone = new ItemStack(misc, 1, 13)) != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{pinecone}, Fluids.SEED_OIL.getFluid(3 * amount));
        }
        if (food != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{new ItemStack(food)}, Fluids.JUICE.getFluid(50), mulch, 5);
        }
        if (persimmon != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{persimmon}, Fluids.JUICE.getFluid(200), mulch, 20);
        }
    }

    private static void addFlowers() {
        Block plants;
        Block mushrooms;
        Block flowers2;
        Block flowers = GameRegistry.findBlock((String)BoP, (String)"flowers");
        if (flowers != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 0, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 1, 1.0, "flowersVanilla", "flowersSnow", "flowersMushrooms");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 3, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 4, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 5, 1.0, "flowersVanilla", "flowersSnow", "flowersJungle");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 6, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 7, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 8, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 9, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 10, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 11, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 12, 1.0, "flowersCacti");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 13, 1.0, "flowersNether");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers, 15, 1.0, "flowersVanilla", "flowersSnow");
        }
        if ((flowers2 = GameRegistry.findBlock((String)BoP, (String)"flowers2")) != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 0, 1.0, "flowersVanilla", "flowersJungle");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 1, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 2, 1.0, "flowersNether");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 3, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 4, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 5, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 6, 1.0, "flowersVanilla");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 7, 1.0, "flowersVanilla", "flowersSnow");
            FlowerManager.flowerRegistry.registerPlantableFlower(flowers2, 8, 1.0, "flowersVanilla");
        }
        if ((mushrooms = GameRegistry.findBlock((String)BoP, (String)"mushrooms")) != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(mushrooms, Short.MAX_VALUE, 1.0, "flowersMushrooms");
            FlowerManager.flowerRegistry.registerPlantableFlower(mushrooms, 3, 1.0, "flowersNether");
        }
        if ((plants = GameRegistry.findBlock((String)BoP, (String)"plants")) != null) {
            FlowerManager.flowerRegistry.registerPlantableFlower(plants, 12, 1.0, "flowersCacti");
        }
    }

    @Override
    public void registerBackpackItems() {
        PluginBiomesOPlenty.addBlocksToBackpack("forestry.miner", "driedDirt", "overgrownNetherrack", "cragRock", "ashStone");
        PluginBiomesOPlenty.addBlocksToBackpack("forestry.digger", "bopGrass", "newBopGrass", "longGrass", "mud", "hardDirt", "hardSand", "originGrass", "ash", "newBopDirt");
        PluginBiomesOPlenty.addBlocksToBackpack("forestry.forester", "petals");
    }

    private static void addBlocksToBackpack(String backpackUid, String ... blockNames) {
        for (String blockName : blockNames) {
            Block block = GameRegistry.findBlock((String)BoP, (String)blockName);
            if (block != null) {
                ItemStack blockStack = new ItemStack(block, 1, Short.MAX_VALUE);
                BackpackManager.backpackInterface.getBackpack(backpackUid).addValidItem(blockStack);
                continue;
            }
            Log.warning("Missing block: ", blockName);
        }
    }
}

