/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.CropBlock;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableGourd
implements IFarmable {
    private final ItemStack seed;
    private final ItemStack stem;
    private final ItemStack fruit;

    public FarmableGourd(ItemStack seed, ItemStack stem, ItemStack fruit) {
        this.seed = seed;
        this.stem = stem;
        this.fruit = fruit;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return false;
        }
        return ItemStackUtil.equals(world.func_180495_p(pos).func_177230_c(), this.stem);
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos) {
        if (world.func_175623_d(pos)) {
            return null;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (!ItemStackUtil.equals(block, this.fruit)) {
            return null;
        }
        if (block.func_176201_c(blockState) != this.fruit.func_77952_i()) {
            return null;
        }
        return new CropBlock(world, ItemStackUtil.getBlock(this.fruit), this.fruit.func_77952_i(), pos);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return this.seed.func_77969_a(itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return world.func_180501_a(pos, ItemStackUtil.getBlock(this.stem).func_176223_P(), 2);
    }
}

