/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.logic.CropBasicAgriCraft;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableBasicAgricraft
implements IFarmable {
    private final Block block;
    private final int matureMeta;

    public FarmableBasicAgricraft(Block block, int matureMeta) {
        this.block = block;
        this.matureMeta = matureMeta;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == this.block;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (block != this.block) {
            return null;
        }
        int blockMetadata = block.func_176201_c(blockState);
        if (blockMetadata != this.matureMeta) {
            return null;
        }
        return new CropBasicAgriCraft(world, this.block, this.matureMeta, pos);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return ItemStackUtil.equals(this.block, itemstack);
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return world.func_180501_a(pos, this.block.func_176223_P(), 2);
    }
}

