/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.core.proxy.Proxies;
import forestry.farming.logic.Crop;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class CropBasicGrowthCraft
extends Crop {
    private final Block block;
    private final int meta;
    private final boolean isRice;
    private final boolean isGrape;

    public CropBasicGrowthCraft(World world, Block block, int meta, BlockPos position, boolean isRice, boolean isGrape) {
        super(world, position);
        this.block = block;
        this.meta = meta;
        this.isRice = isRice;
        this.isGrape = isGrape;
    }

    @Override
    protected boolean isCrop(BlockPos pos) {
        return this.getBlock(pos) == this.block && this.getBlockMeta(pos) == this.meta;
    }

    @Override
    protected Collection<ItemStack> harvestBlock(BlockPos pos) {
        List harvest = this.block.getDrops((IBlockAccess)this.world, pos, this.block.func_176203_a(this.meta), 0);
        if (harvest.size() > 1) {
            harvest.remove(0);
        }
        Proxies.common.addBlockDestroyEffects(this.world, pos, this.block.func_176223_P());
        if (this.isGrape) {
            this.world.func_175698_g(pos);
        } else {
            this.world.func_180501_a(pos, this.block.func_176223_P(), 2);
        }
        if (this.isRice) {
            this.world.func_180501_a(pos.func_177977_b(), this.block.func_176203_a(7), 2);
        }
        return harvest;
    }

    public String toString() {
        return String.format("CropBasicGrowthCraft [ position: [ %s ]; block: %s; meta: %s ]", this.position.toString(), this.block.func_149739_a(), this.meta);
    }
}

