/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.entities;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;

public abstract class EntitySelector<T extends Entity>
implements Predicate<T> {
    private final Class<T> entityClass;

    protected EntitySelector(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public boolean apply(Entity entity) {
        if (entity == null) {
            return false;
        }
        Entity castEntity = (Entity)this.entityClass.cast(entity);
        return this.isEntityApplicableTyped(castEntity);
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    protected abstract boolean isEntityApplicableTyped(T var1);
}

