/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.storage.IBackpackDefinition;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Translator;
import java.awt.Color;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.oredict.OreDictionary;

public class BackpackDefinition
implements IBackpackDefinition {
    private final int primaryColor;
    private final int secondaryColor;
    private final Set<String> validItemStacks = new HashSet<String>();
    private final Set<Integer> validOreIds = new HashSet<Integer>();

    public BackpackDefinition(@Nonnull Color primaryColor) {
        this(primaryColor, new Color(0xFFFFFF));
    }

    public BackpackDefinition(@Nonnull Color primaryColor, @Nonnull Color secondaryColor) {
        this.primaryColor = primaryColor.getRGB();
        this.secondaryColor = secondaryColor.getRGB();
    }

    @Override
    public String getName(ItemStack backpack) {
        NBTTagCompound nbt;
        Item item = backpack.func_77973_b();
        String display = Translator.translateToLocal(item.func_77657_g(backpack) + ".name").trim();
        if (backpack.func_77942_o() && backpack.func_77978_p().func_150297_b("display", 10) && (nbt = backpack.func_77978_p().func_74775_l("display")).func_150297_b("Name", 8)) {
            display = nbt.func_74779_i("Name");
        }
        return display;
    }

    @Override
    public int getPrimaryColour() {
        return this.primaryColor;
    }

    @Override
    public int getSecondaryColour() {
        return this.secondaryColor;
    }

    @Override
    public void addValidItem(ItemStack validItem) {
        String itemStackString = ItemStackUtil.getStringForItemStack(validItem);
        if (itemStackString != null) {
            this.validItemStacks.add(itemStackString);
        }
    }

    public void clearAllValid() {
        this.validItemStacks.clear();
        this.validOreIds.clear();
    }

    @Override
    public void addValidItems(List<ItemStack> validItems) {
        for (ItemStack validItem : validItems) {
            this.addValidItem(validItem);
        }
    }

    @Override
    public void addValidOreDictName(String oreDictName) {
        if (OreDictionary.doesOreNameExist((String)oreDictName)) {
            int oreId = OreDictionary.getOreID((String)oreDictName);
            this.validOreIds.add(oreId);
        }
    }

    public void addValidOreDictNames(List<String> oreDictNames) {
        for (String oreDictName : oreDictNames) {
            this.addValidOreDictName(oreDictName);
        }
    }

    @Override
    public boolean test(ItemStack itemStack) {
        int[] oreIds;
        String itemStackString;
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item == null) {
            return false;
        }
        String itemStackStringWild = ItemStackUtil.getItemNameFromRegistryAsString(item);
        if (this.validItemStacks.contains(itemStackStringWild)) {
            return true;
        }
        int meta = itemStack.func_77952_i();
        if (meta != Short.MAX_VALUE && this.validItemStacks.contains(itemStackString = itemStackStringWild + ':' + meta)) {
            return true;
        }
        for (int oreId : oreIds = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            if (!this.validOreIds.contains(oreId)) continue;
            this.validItemStacks.add(itemStackStringWild);
            return true;
        }
        return false;
    }

    public static class BackpackDefinitionNaturalist
    extends BackpackDefinition {
        @Nonnull
        private final String speciesRootUid;

        public BackpackDefinitionNaturalist(@Nonnull Color primaryColor, @Nonnull String speciesRootUid) {
            super(primaryColor);
            this.speciesRootUid = speciesRootUid;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(this.speciesRootUid);
            return speciesRoot.isMember(itemStack);
        }
    }
}

