/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.core.fluids.Fluids;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.farming.FarmHelper;
import forestry.farming.logic.FarmLogic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public abstract class FarmLogicWatered
extends FarmLogic {
    protected final ItemStack ground;
    private final ItemStack resource;
    private static final FluidStack STACK_WATER = Fluids.WATER.getFluid(1000);
    List<ItemStack> produce = new ArrayList<ItemStack>();

    protected FarmLogicWatered(IFarmHousing housing, ItemStack resource, ItemStack ground) {
        super(housing);
        this.ground = ground;
        this.resource = resource;
    }

    @Override
    public int getFertilizerConsumption() {
        return 5;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(20.0f * hydrationModifier);
    }

    protected boolean isAcceptedGround(ItemStack ground) {
        return ItemStackUtil.isIdenticalItem(this.ground, ground);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return this.resource.func_77969_a(itemstack);
    }

    @Override
    public Collection<ItemStack> collect() {
        List<ItemStack> products = this.produce;
        this.produce = new ArrayList<ItemStack>();
        return products;
    }

    @Override
    public boolean cultivate(BlockPos pos, FarmDirection direction, int extent) {
        if (this.maintainSoil(pos, direction, extent)) {
            return true;
        }
        if (!this.isManual && this.maintainWater(pos, direction, extent)) {
            return true;
        }
        return this.maintainCrops(pos.func_177982_a(0, 1, 0), direction, extent);
    }

    private boolean maintainSoil(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        ItemStack[] resources = new ItemStack[]{this.resource};
        for (int i = 0; i < extent; ++i) {
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            Block soil = state.func_177230_c();
            ItemStack soilStack = soil.getPickBlock(state, null, world, position, null);
            if (this.isAcceptedGround(soilStack) || !this.housing.getFarmInventory().hasResources(resources)) continue;
            BlockPos platformPosition = position.func_177977_b();
            IBlockState blockState = world.func_180495_p(platformPosition);
            Block platformBlock = blockState.func_177230_c();
            if (!FarmHelper.bricks.contains((Object)platformBlock)) break;
            if (!soil.isAir(state, (IBlockAccess)world, platformPosition) && !BlockUtil.isReplaceableBlock(state, world, platformPosition)) {
                this.produce.addAll(BlockUtil.getBlockDrops(this.getWorld(), position));
                world.func_175698_g(position);
                return this.trySetSoil(position);
            }
            if (this.isManual || this.isWaterSourceBlock(world, position)) continue;
            if (this.trySetWater(world, position)) {
                return true;
            }
            return this.trySetSoil(position);
        }
        return false;
    }

    private boolean maintainWater(BlockPos pos, FarmDirection direction, int extent) {
        BlockPos position;
        BlockPos platformPosition;
        IBlockState blockState;
        Block platformBlock;
        World world = this.getWorld();
        for (int i = 0; i < extent && FarmHelper.bricks.contains((Object)(platformBlock = (blockState = world.func_180495_p(platformPosition = (position = this.translateWithOffset(pos, direction, i)).func_177977_b())).func_177230_c())); ++i) {
            if (!this.trySetWater(world, position)) continue;
            return true;
        }
        return false;
    }

    protected boolean maintainCrops(BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    private boolean trySetSoil(BlockPos position) {
        ItemStack[] resources = new ItemStack[]{this.resource};
        if (!this.housing.getFarmInventory().hasResources(resources)) {
            return false;
        }
        this.setBlock(position, ItemStackUtil.getBlock(this.ground), this.ground.func_77952_i());
        this.housing.getFarmInventory().removeResources(resources);
        return true;
    }

    private boolean trySetWater(World world, BlockPos position) {
        if (this.isWaterSourceBlock(world, position) || !this.canPlaceWater(world, position)) {
            return false;
        }
        if (!this.housing.hasLiquid(STACK_WATER)) {
            return false;
        }
        this.produce.addAll(BlockUtil.getBlockDrops(world, position));
        this.setBlock(position, (Block)Blocks.field_150355_j, 0);
        this.housing.removeLiquid(STACK_WATER);
        return true;
    }

    private boolean canPlaceWater(World world, BlockPos position) {
        int x;
        for (x = -2; x <= 2; ++x) {
            for (int z = -2; z <= 2; ++z) {
                BlockPos offsetPosition = position.func_177982_a(x, 0, z);
                if (!this.isWaterSourceBlock(world, offsetPosition)) continue;
                return false;
            }
        }
        for (x = -1; x <= 1; ++x) {
            BlockPos offsetPosition = position.func_177982_a(x, 0, 0);
            if (!world.func_175623_d(offsetPosition)) continue;
            return false;
        }
        for (int z = -1; z <= 1; ++z) {
            BlockPos offsetPosition = position.func_177982_a(0, 0, z);
            if (!world.func_175623_d(offsetPosition)) continue;
            return false;
        }
        return true;
    }
}

