/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.farming.logic.CropRubber;
import forestry.farming.logic.FarmLogic;
import forestry.plugins.compat.PluginIC2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FarmLogicRubber
extends FarmLogic {
    private boolean inActive;
    private final Map<BlockPos, Integer> lastExtents = new HashMap<BlockPos, Integer>();

    public FarmLogicRubber(IFarmHousing housing) {
        super(housing);
        if (PluginIC2.rubberWood == null || PluginIC2.resin == null) {
            Log.warning("Failed to init a farm logic %s since IC2 was not found", this.getClass().getName());
            this.inActive = true;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item getItem() {
        if (!this.inActive) {
            return PluginIC2.resin.func_77973_b();
        }
        return Items.field_151016_H;
    }

    @Override
    public String getName() {
        return "Rubber Plantation";
    }

    @Override
    public int getFertilizerConsumption() {
        return 40;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(5.0f * hydrationModifier);
    }

    @Override
    public boolean isAcceptedResource(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack stack) {
        return false;
    }

    @Override
    public Collection<ItemStack> collect() {
        return null;
    }

    @Override
    public boolean cultivate(BlockPos pos, FarmDirection direction, int extent) {
        return false;
    }

    @Override
    public Collection<ICrop> harvest(BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (this.inActive) {
            return null;
        }
        if (!this.lastExtents.containsKey(pos)) {
            this.lastExtents.put(pos, 0);
        }
        if ((lastExtent = this.lastExtents.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177982_a(0, 1, 0), direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(position);
        this.lastExtents.put(pos, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(BlockPos position) {
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        World world = this.getWorld();
        IBlockState blockState = world.func_180495_p(position);
        Block block = blockState.func_177230_c();
        if (!ItemStackUtil.equals(block, PluginIC2.rubberWood)) {
            return crops;
        }
        int meta = block.func_176201_c(blockState);
        if (meta >= 2 && meta <= 5) {
            crops.push(new CropRubber(this.getWorld(), block, meta, position));
        }
        List<BlockPos> candidates = this.processHarvestBlock(crops, seen, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty() && crops.size() < 100) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(crops, seen, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(Stack<ICrop> crops, Set<BlockPos> seen, BlockPos position) {
        World world = this.getWorld();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int j = 0; j < 2; ++j) {
            IBlockState blockState;
            Block block;
            BlockPos candidate = position.func_177982_a(0, j, 0);
            if (candidate.equals((Object)position) || seen.contains(candidate) || !ItemStackUtil.equals(block = (blockState = world.func_180495_p(candidate)).func_177230_c(), PluginIC2.rubberWood)) continue;
            int meta = block.func_176201_c(blockState);
            if (meta >= 2 && meta <= 5) {
                crops.push(new CropRubber(world, block, meta, candidate));
            }
            candidates.add(candidate);
            seen.add(candidate);
        }
        return candidates;
    }
}

