/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.Farmables;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmable;
import forestry.core.PluginCore;
import forestry.core.blocks.BlockSoil;
import forestry.farming.logic.FarmLogicHomogeneous;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FarmLogicArboreal
extends FarmLogicHomogeneous {
    private static final int BRANCH_RANGE = 20;
    private final Map<BlockPos, Integer> lastExtentsHarvest = new HashMap<BlockPos, Integer>();

    public FarmLogicArboreal(IFarmHousing housing, ItemStack resource, ItemStack ground, Iterable<IFarmable> germlings) {
        super(housing, resource, ground, germlings);
    }

    public FarmLogicArboreal(IFarmHousing housing) {
        super(housing, new ItemStack(Blocks.field_150346_d), PluginCore.blocks.soil.get(BlockSoil.SoilType.HUMUS, 1), (Iterable<IFarmable>)Farmables.farmables.get("farmArboreal"));
    }

    @Override
    public boolean isAcceptedSoil(ItemStack soil) {
        if (super.isAcceptedSoil(soil)) {
            return true;
        }
        Block block = Block.func_149634_a((Item)soil.func_77973_b());
        if (!(block instanceof BlockSoil)) {
            return false;
        }
        BlockSoil blockSoil = (BlockSoil)block;
        return BlockSoil.getTypeFromMeta(soil.func_77952_i()) == BlockSoil.SoilType.HUMUS;
    }

    @Override
    public String getName() {
        return "Managed Arboretum";
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Item getItem() {
        return Item.func_150898_a((Block)Blocks.field_150345_g);
    }

    @Override
    public int getFertilizerConsumption() {
        return 10;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return (int)(10.0f * hydrationModifier);
    }

    @Override
    public Collection<ItemStack> collect() {
        List products = this.produce;
        this.produce = this.collectEntityItems(true);
        return products;
    }

    @Override
    public Collection<ICrop> harvest(BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (!this.lastExtentsHarvest.containsKey(pos)) {
            this.lastExtentsHarvest.put(pos, 0);
        }
        if ((lastExtent = this.lastExtentsHarvest.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, lastExtent);
        Collection<ICrop> crops = this.getHarvestBlocks(position);
        this.lastExtentsHarvest.put(pos, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> getHarvestBlocks(BlockPos position) {
        World world = this.getWorld();
        HashSet<BlockPos> seen = new HashSet<BlockPos>();
        Stack<ICrop> crops = new Stack<ICrop>();
        IFarmable germling = null;
        for (IFarmable germl : this.germlings) {
            ICrop crop = germl.getCropAt(world, position);
            if (crop == null) continue;
            crops.push(crop);
            seen.add(position);
            germling = germl;
            break;
        }
        if (germling == null) {
            return crops;
        }
        List<BlockPos> candidates = this.processHarvestBlock(germling, crops, seen, position, position);
        ArrayList<BlockPos> temp = new ArrayList<BlockPos>();
        while (!candidates.isEmpty()) {
            for (BlockPos candidate : candidates) {
                temp.addAll(this.processHarvestBlock(germling, crops, seen, position, candidate));
            }
            candidates.clear();
            candidates.addAll(temp);
            temp.clear();
        }
        return crops;
    }

    private List<BlockPos> processHarvestBlock(IFarmable germling, Stack<ICrop> crops, Set<BlockPos> seen, BlockPos start, BlockPos position) {
        World world = this.getWorld();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    ICrop crop;
                    BlockPos candidate = position.func_177982_a(x, y, z);
                    if (candidate.equals((Object)position) || Math.abs(candidate.func_177958_n() - start.func_177958_n()) > 20 || Math.abs(candidate.func_177952_p() - start.func_177952_p()) > 20 || seen.contains(candidate) || (crop = germling.getCropAt(world, candidate)) == null) continue;
                    crops.push(crop);
                    candidates.add(candidate);
                    seen.add(candidate);
                }
            }
        }
        return candidates;
    }

    @Override
    protected boolean maintainGermlings(BlockPos pos, FarmDirection direction, int extent) {
        World world = this.getWorld();
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPosition;
            IBlockState soilState;
            Block soilBlock;
            ItemStack soilBelow;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            if (!world.func_175623_d(position) || !this.isAcceptedSoil(soilBelow = (soilBlock = (soilState = world.func_180495_p(soilPosition = position.func_177977_b())).func_177230_c()).getPickBlock(soilState, null, world, soilPosition, null))) continue;
            return this.plantSapling(position);
        }
        return false;
    }

    private boolean plantSapling(BlockPos position) {
        World world = this.getWorld();
        Collections.shuffle(this.germlings);
        for (IFarmable candidate : this.germlings) {
            if (!this.housing.plantGermling(candidate, world, position)) continue;
            return true;
        }
        return false;
    }
}

