/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockType;
import forestry.core.utils.VectUtil;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class WorldGenHelper {
    public static boolean addBlock(World world, BlockPos pos, ITreeBlockType type, EnumReplaceMode replaceMode) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (replaceMode.canReplace(blockState, world, pos)) {
            type.setBlock(world, pos);
            return true;
        }
        return false;
    }

    public static void generateCylinderFromTreeStartPos(World world, ITreeBlockType block, BlockPos startPos, int girth, float radius, int height, EnumReplaceMode replace) {
        WorldGenHelper.generateCylinderFromPos(world, block, startPos.func_177982_a(girth / 2, 0, girth / 2), radius, height, replace);
    }

    public static void generateCylinderFromPos(World world, ITreeBlockType block, BlockPos center, float radius, int height, EnumReplaceMode replace) {
        BlockPos start = new BlockPos((double)((float)center.func_177958_n() - radius), (double)center.func_177956_o(), (double)((float)center.func_177952_p() - radius));
        int x = 0;
        while ((float)x < radius * 2.0f + 1.0f) {
            for (int y = height - 1; y >= 0; --y) {
                int z = 0;
                while ((float)z < radius * 2.0f + 1.0f) {
                    Vec3i treeCenter;
                    BlockPos position = start.func_177982_a(x, y, z);
                    if (position.func_177951_i(treeCenter = new Vec3i(center.func_177958_n(), position.func_177956_o(), center.func_177952_p())) <= (double)(radius * radius) + 0.01) {
                        EnumFacing direction = VectUtil.direction((Vec3i)position, treeCenter);
                        block.setDirection(direction);
                        WorldGenHelper.addBlock(world, position, block, replace);
                    }
                    ++z;
                }
            }
            ++x;
        }
    }

    public static void generateCircleFromTreeStartPos(World world, Random rand, BlockPos startPos, int girth, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace) {
        WorldGenHelper.generateCircle(world, rand, startPos.func_177982_a(girth / 2, 0, girth / 2), radius, width, height, block, chance, replace);
    }

    public static void generateCircle(World world, Random rand, BlockPos center, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace) {
        Vec3i start = new Vec3i((double)((float)center.func_177958_n() - radius), (double)center.func_177956_o(), (double)((float)center.func_177952_p() - radius));
        Vec3i area = new Vec3i((double)(radius * 2.0f + 1.0f), (double)height, (double)(radius * 2.0f + 1.0f));
        for (int x = start.func_177958_n(); x < start.func_177958_n() + area.func_177958_n(); ++x) {
            for (int y = start.func_177956_o() + area.func_177956_o() - 1; y >= start.func_177956_o(); --y) {
                for (int z = start.func_177952_p(); z < start.func_177952_p() + area.func_177952_p(); ++z) {
                    double distance;
                    if (rand.nextFloat() > chance || !((double)(radius - (float)width) - 0.01 < (distance = new Vec3i(x, y, z).func_185332_f(center.func_177958_n(), y, center.func_177952_p()))) || !(distance <= (double)radius + 0.01)) continue;
                    WorldGenHelper.addBlock(world, new BlockPos(x, y, z), block, replace);
                }
            }
        }
    }

    public static void generateSphereFromTreeStartPos(World world, BlockPos startPos, int girth, int radius, ITreeBlockType block, EnumReplaceMode replace) {
        WorldGenHelper.generateSphere(world, startPos.func_177982_a(girth / 2, 0, girth / 2), radius, block, replace);
    }

    public static void generateSphere(World world, BlockPos center, int radius, ITreeBlockType block, EnumReplaceMode replace) {
        Vec3i start = new Vec3i(center.func_177958_n() - radius, center.func_177956_o() - radius, center.func_177952_p() - radius);
        Vec3i area = new Vec3i(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        for (int x = start.func_177958_n(); x < start.func_177958_n() + area.func_177958_n(); ++x) {
            for (int y = start.func_177956_o() + area.func_177956_o() - 1; y >= start.func_177956_o(); --y) {
                for (int z = start.func_177952_p(); z < start.func_177952_p() + area.func_177952_p(); ++z) {
                    if (!(center.func_185332_f(x, y, z) <= (double)radius + 0.01)) continue;
                    WorldGenHelper.addBlock(world, new BlockPos(x, y, z), block, replace);
                }
            }
        }
    }

    public static Set<BlockPos> generateTreeTrunk(@Nonnull World world, Random rand, @Nonnull ITreeBlockType wood, @Nonnull BlockPos startPos, int height, int girth, int yStart, float vinesChance, @Nullable EnumFacing leanDirection, float leanScale) {
        HashSet<BlockPos> treeTops = new HashSet<BlockPos>();
        int leanStartY = (int)Math.floor((float)height * 0.33f);
        int prevXOffset = 0;
        int prevZOffset = 0;
        int leanX = 0;
        int leanZ = 0;
        if (leanDirection != null) {
            leanX = leanDirection.func_82601_c();
            leanZ = leanDirection.func_82599_e();
        }
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                for (int y = height - 1; y >= yStart; --y) {
                    float lean = y < leanStartY ? 0.0f : leanScale * (float)(y - leanStartY) / (float)(height - leanStartY);
                    int xOffset = (int)Math.floor((float)leanX * lean);
                    int zOffset = (int)Math.floor((float)leanZ * lean);
                    if (xOffset != prevXOffset || zOffset != prevZOffset) {
                        prevXOffset = xOffset;
                        prevZOffset = zOffset;
                        if (y > 0) {
                            wood.setDirection(leanDirection);
                            WorldGenHelper.addBlock(world, startPos.func_177982_a(x + xOffset, y - 1, z + zOffset), wood, EnumReplaceMode.ALL);
                            wood.setDirection(EnumFacing.UP);
                        }
                    }
                    BlockPos pos = startPos.func_177982_a(x + xOffset, y, z + zOffset);
                    WorldGenHelper.addBlock(world, pos, wood, EnumReplaceMode.ALL);
                    WorldGenHelper.addVines(world, rand, pos, vinesChance);
                    if (y + 1 != height) continue;
                    treeTops.add(pos);
                }
            }
        }
        return treeTops;
    }

    protected static void addVines(World world, Random rand, BlockPos pos, float chance) {
        IBlockState blockState;
        if (chance <= 0.0f) {
            return;
        }
        if (rand.nextFloat() < chance) {
            blockState = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true));
            WorldGenHelper.addBlock(world, pos.func_177976_e(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.nextFloat() < chance) {
            blockState = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true));
            WorldGenHelper.addBlock(world, pos.func_177974_f(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.nextFloat() < chance) {
            blockState = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true));
            WorldGenHelper.addBlock(world, pos.func_177978_c(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
        if (rand.nextFloat() < chance) {
            blockState = Blocks.field_150395_bd.func_176223_P().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true));
            WorldGenHelper.addBlock(world, pos.func_177968_d(), new TreeBlockType(blockState), EnumReplaceMode.AIR);
        }
    }

    public static void generatePods(ITreeGenData tree, World world, Random rand, BlockPos startPos, int height, int minHeight, int girth, EnumReplaceMode replaceMode) {
        for (int y = height - 1; y >= minHeight; --y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    WorldGenHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x + 1, y, z), replaceMode);
                    WorldGenHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x - 1, y, z), replaceMode);
                    WorldGenHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x, y, z + 1), replaceMode);
                    WorldGenHelper.trySpawnFruitBlock(tree, world, rand, startPos.func_177982_a(x, y, z - 1), replaceMode);
                }
            }
        }
    }

    private static void trySpawnFruitBlock(ITreeGenData tree, World world, Random rand, BlockPos pos, EnumReplaceMode replaceMode) {
        IBlockState blockState = world.func_180495_p(pos);
        if (replaceMode.canReplace(blockState, world, pos)) {
            tree.trySpawnFruitBlock(world, rand, pos);
        }
    }

    public static void generateSupportStems(ITreeBlockType wood, World world, Random rand, BlockPos startPos, int height, int girth, float chance, float maxHeight) {
        int min = -1;
        int max = girth;
        for (int x = -1; x <= max; ++x) {
            for (int z = -1; z <= max; ++z) {
                if (x == -1 && z == -1 || x == max && z == max || x == -1 && z == max || x == max && z == -1) continue;
                int stemHeight = rand.nextInt(Math.round((float)height * maxHeight));
                if (!(rand.nextFloat() < chance)) continue;
                for (int y = 0; y < stemHeight; ++y) {
                    WorldGenHelper.addBlock(world, startPos.func_177982_a(x, y, z), wood, EnumReplaceMode.SOFT);
                }
            }
        }
    }

    public static Set<BlockPos> generateBranches(World world, Random rand, ITreeBlockType wood, BlockPos startPos, int girth, float spreadY, float spreadXZ, int radius, int count, float chance) {
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        if (radius < 1) {
            radius = 1;
        }
        for (EnumFacing branchDirection : EnumFacing.field_176754_o) {
            wood.setDirection(branchDirection);
            BlockPos branchStart = startPos;
            int offsetX = branchDirection.func_82601_c();
            int offsetZ = branchDirection.func_82599_e();
            if (offsetX > 0) {
                branchStart = branchStart.func_177982_a(girth - 1, 0, 0);
            }
            if (offsetZ > 0) {
                branchStart = branchStart.func_177982_a(0, 0, girth - 1);
            }
            block1: for (int i = 0; i < count; ++i) {
                if (rand.nextFloat() > chance) continue;
                int y = 0;
                int x = 0;
                int z = 0;
                for (int r = 0; r < radius; ++r) {
                    if (rand.nextFloat() < spreadY) {
                        ++y;
                        wood.setDirection(EnumFacing.UP);
                    } else if (rand.nextFloat() < spreadXZ) {
                        if (branchDirection.func_176740_k() == EnumFacing.Axis.Z) {
                            x = rand.nextBoolean() ? ++x : --x;
                            wood.setDirection(EnumFacing.EAST);
                        } else if (branchDirection.func_176740_k() == EnumFacing.Axis.X) {
                            z = rand.nextBoolean() ? ++z : --z;
                            wood.setDirection(EnumFacing.SOUTH);
                        }
                    } else {
                        x += offsetX;
                        z += offsetZ;
                        wood.setDirection(branchDirection);
                    }
                    BlockPos pos = branchStart.func_177982_a(x, y, z);
                    if (!WorldGenHelper.addBlock(world, pos, wood, EnumReplaceMode.SOFT)) continue block1;
                    branchEnds.add(pos);
                }
            }
        }
        return branchEnds;
    }

    public static enum Direction {
        NORTH(EnumFacing.NORTH),
        SOUTH(EnumFacing.SOUTH),
        WEST(EnumFacing.WEST),
        EAST(EnumFacing.EAST);

        public final EnumFacing facing;

        private Direction(EnumFacing forgeDirection) {
            this.facing = forgeDirection;
        }

        public static Direction getRandom(Random random) {
            return Direction.values()[random.nextInt(Direction.values().length)];
        }

        public static Direction getRandomOther(Random random, Direction direction) {
            EnumSet<Direction> directions = EnumSet.allOf(Direction.class);
            directions.remove((Object)direction);
            int size = directions.size();
            return directions.toArray(new Direction[size])[random.nextInt(size)];
        }
    }

    public static enum EnumReplaceMode {
        AIR{

            @Override
            public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
                return world.func_175623_d(pos);
            }
        }
        ,
        ALL{

            @Override
            public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
                return true;
            }
        }
        ,
        SOFT{

            @Override
            public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
                return blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
            }
        };


        public abstract boolean canReplace(IBlockState var1, World var2, BlockPos var3);
    }
}

