/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.core.multiblock.IMultiblockControllerInternal;
import forestry.core.multiblock.MultiblockLogic;
import forestry.core.multiblock.MultiblockRegistry;
import forestry.core.multiblock.MultiblockUtil;
import forestry.core.multiblock.MultiblockValidationException;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;

public abstract class MultiblockControllerBase
implements IMultiblockControllerInternal {
    protected World worldObj;
    private static final Random rand = new Random();
    private int tickCount = rand.nextInt(256);
    protected AssemblyState assemblyState;
    protected HashSet<IMultiblockComponent> connectedParts;
    private BlockPos referenceCoord;
    private BlockPos minimumCoord;
    private BlockPos maximumCoord;
    private boolean shouldCheckForDisconnections;
    private MultiblockValidationException lastValidationException;

    protected MultiblockControllerBase(World world) {
        this.worldObj = world;
        this.connectedParts = new HashSet();
        this.referenceCoord = null;
        this.assemblyState = AssemblyState.Disassembled;
        this.minimumCoord = null;
        this.maximumCoord = null;
        this.shouldCheckForDisconnections = true;
        this.lastValidationException = null;
    }

    @Override
    @Nonnull
    public Collection<IMultiblockComponent> getComponents() {
        return Collections.unmodifiableCollection(this.connectedParts);
    }

    protected abstract void onAttachedPartWithMultiblockData(IMultiblockComponent var1, NBTTagCompound var2);

    @Override
    public void attachBlock(IMultiblockComponent part) {
        BlockPos coord = part.getCoordinates();
        if (!this.connectedParts.add(part)) {
            Log.warning("[%s] Controller %s is double-adding part %d @ %s. This is unusual. If you encounter odd behavior, please tear down the machine and rebuild it.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", this.hashCode(), part.hashCode(), coord);
        }
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.setController(this);
        this.onBlockAdded(part);
        if (logic.hasMultiblockSaveData()) {
            NBTTagCompound savedData = logic.getMultiblockSaveData();
            this.onAttachedPartWithMultiblockData(part, savedData);
            logic.onMultiblockDataAssimilated();
        }
        if (this.referenceCoord == null) {
            this.referenceCoord = coord;
            logic.becomeMultiblockSaveDelegate();
        } else if (coord.compareTo((Vec3i)this.referenceCoord) < 0) {
            TileEntity te = this.worldObj.func_175625_s(this.referenceCoord);
            if (te instanceof IMultiblockComponent) {
                IMultiblockComponent tePart = (IMultiblockComponent)te;
                MultiblockLogic teLogic = (MultiblockLogic)tePart.getMultiblockLogic();
                teLogic.forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = coord;
            logic.becomeMultiblockSaveDelegate();
        } else {
            logic.forfeitMultiblockSaveDelegate();
        }
        if (this.minimumCoord != null) {
            if (coord.func_177958_n() < this.minimumCoord.func_177958_n()) {
                this.minimumCoord = new BlockPos(coord.func_177958_n(), this.minimumCoord.func_177956_o(), this.minimumCoord.func_177952_p());
            }
            if (coord.func_177956_o() < this.minimumCoord.func_177956_o()) {
                this.minimumCoord = new BlockPos(this.minimumCoord.func_177958_n(), coord.func_177956_o(), this.minimumCoord.func_177952_p());
            }
            if (coord.func_177952_p() < this.minimumCoord.func_177952_p()) {
                this.minimumCoord = new BlockPos(this.minimumCoord.func_177958_n(), this.minimumCoord.func_177956_o(), coord.func_177952_p());
            }
        }
        if (this.maximumCoord != null) {
            if (coord.func_177958_n() > this.maximumCoord.func_177958_n()) {
                this.maximumCoord = new BlockPos(coord.func_177958_n(), this.maximumCoord.func_177956_o(), this.maximumCoord.func_177952_p());
            }
            if (coord.func_177956_o() > this.maximumCoord.func_177956_o()) {
                this.maximumCoord = new BlockPos(this.maximumCoord.func_177958_n(), coord.func_177956_o(), this.maximumCoord.func_177952_p());
            }
            if (coord.func_177952_p() > this.maximumCoord.func_177952_p()) {
                this.maximumCoord = new BlockPos(this.maximumCoord.func_177958_n(), this.maximumCoord.func_177956_o(), coord.func_177952_p());
            }
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void onBlockAdded(IMultiblockComponent var1);

    protected abstract void onBlockRemoved(IMultiblockComponent var1);

    protected void onMachineAssembled() {
    }

    protected void onMachineRestored() {
    }

    protected void onMachinePaused() {
    }

    protected void onMachineDisassembled() {
    }

    private void onDetachBlock(IMultiblockComponent part) {
        MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
        logic.setController(null);
        this.onBlockRemoved(part);
        logic.forfeitMultiblockSaveDelegate();
        this.maximumCoord = null;
        this.minimumCoord = null;
        if (this.referenceCoord != null && this.referenceCoord.equals((Object)part.getCoordinates())) {
            this.referenceCoord = null;
        }
        this.shouldCheckForDisconnections = true;
    }

    @Override
    public void detachBlock(IMultiblockComponent part, boolean chunkUnloading) {
        if (chunkUnloading && this.assemblyState == AssemblyState.Assembled) {
            this.assemblyState = AssemblyState.Paused;
            this.onMachinePaused();
        }
        this.onDetachBlock(part);
        if (!this.connectedParts.remove(part)) {
            BlockPos partCoords = part.getCoordinates();
            Log.warning("[%s] Double-removing part (%d) @ %d, %d, %d, this is unexpected and may cause problems. If you encounter anomalies, please tear down the reactor and rebuild it.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", part.hashCode(), partCoords.func_177958_n(), partCoords.func_177956_o(), partCoords.func_177952_p());
        }
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        MultiblockRegistry.addDirtyController(this.worldObj, this);
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
    }

    @Override
    public String getLastValidationError() {
        if (this.lastValidationException == null) {
            return null;
        }
        return this.lastValidationException.getMessage();
    }

    @Override
    public void reassemble() {
        MultiblockRegistry.addDirtyController(this.worldObj, this);
    }

    protected abstract void isMachineWhole() throws MultiblockValidationException;

    @Override
    public void checkIfMachineIsWhole() {
        boolean isWhole;
        AssemblyState oldState = this.assemblyState;
        this.lastValidationException = null;
        try {
            this.isMachineWhole();
            isWhole = true;
        }
        catch (MultiblockValidationException e) {
            this.lastValidationException = e;
            isWhole = false;
        }
        if (isWhole) {
            this.assembleMachine(oldState);
        } else if (oldState == AssemblyState.Assembled) {
            this.disassembleMachine();
        }
    }

    private void assembleMachine(AssemblyState oldState) {
        this.assemblyState = AssemblyState.Assembled;
        for (IMultiblockComponent part : this.connectedParts) {
            part.onMachineAssembled(this, this.getMinimumCoord(), this.getMaximumCoord());
        }
        if (oldState == AssemblyState.Paused) {
            this.onMachineRestored();
        } else {
            this.onMachineAssembled();
        }
    }

    private void disassembleMachine() {
        this.assemblyState = AssemblyState.Disassembled;
        for (IMultiblockComponent part : this.connectedParts) {
            part.onMachineBroken();
        }
        this.onMachineDisassembled();
    }

    @Override
    public void assimilate(IMultiblockControllerInternal other) {
        BlockPos otherReferenceCoord = other.getReferenceCoord();
        if (otherReferenceCoord != null && this.getReferenceCoord().compareTo((Vec3i)otherReferenceCoord) >= 0) {
            throw new IllegalArgumentException("The controller with the lowest minimum-coord value must consume the one with the higher coords");
        }
        HashSet<IMultiblockComponent> partsToAcquire = new HashSet<IMultiblockComponent>(other.getComponents());
        other._onAssimilated(this);
        for (IMultiblockComponent acquiredPart : partsToAcquire) {
            if (MultiblockControllerBase.isInvalid(acquiredPart)) continue;
            this.connectedParts.add(acquiredPart);
            MultiblockLogic logic = (MultiblockLogic)acquiredPart.getMultiblockLogic();
            logic.setController(this);
            this.onBlockAdded(acquiredPart);
        }
        this.onAssimilate(other);
        other.onAssimilated(this);
    }

    @Override
    public void _onAssimilated(IMultiblockControllerInternal otherController) {
        if (this.referenceCoord != null) {
            TileEntity te;
            if (this.worldObj.func_72863_F().func_186026_b(this.referenceCoord.func_177958_n() >> 4, this.referenceCoord.func_177952_p() >> 4) != null && (te = this.worldObj.func_175625_s(this.referenceCoord)) instanceof IMultiblockComponent) {
                IMultiblockComponent part = (IMultiblockComponent)te;
                MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
                logic.forfeitMultiblockSaveDelegate();
            }
            this.referenceCoord = null;
        }
        this.connectedParts.clear();
    }

    protected abstract void onAssimilate(IMultiblockControllerInternal var1);

    @Override
    public abstract void onAssimilated(IMultiblockControllerInternal var1);

    @Override
    public final void updateMultiblockEntity() {
        ++this.tickCount;
        if (this.connectedParts.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return;
        }
        if (this.onlyUpdateWhenAssembled() && this.assemblyState != AssemblyState.Assembled) {
            return;
        }
        if (this.worldObj.field_72995_K) {
            this.updateClient(this.tickCount);
        } else if (this.updateServer(this.tickCount) && this.minimumCoord != null && this.maximumCoord != null && BlockUtil.checkChunksExist(this.worldObj, this.minimumCoord, this.maximumCoord)) {
            int minChunkX = this.minimumCoord.func_177958_n() >> 4;
            int minChunkZ = this.minimumCoord.func_177952_p() >> 4;
            int maxChunkX = this.maximumCoord.func_177958_n() >> 4;
            int maxChunkZ = this.maximumCoord.func_177952_p() >> 4;
            for (int x = minChunkX; x <= maxChunkX; ++x) {
                for (int z = minChunkZ; z <= maxChunkZ; ++z) {
                    Chunk chunkToSave = this.worldObj.func_72964_e(x, z);
                    chunkToSave.func_76630_e();
                }
            }
        }
    }

    protected abstract boolean updateServer(int var1);

    protected abstract void updateClient(int var1);

    protected final boolean updateOnInterval(int tickInterval) {
        return this.tickCount % tickInterval == 0;
    }

    protected void isBlockGoodForExteriorLevel(int level, World world, BlockPos pos) throws MultiblockValidationException {
        Block block = world.func_180495_p(pos).func_177230_c();
        throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.interior", block.func_149732_F()));
    }

    protected void isBlockGoodForInterior(World world, BlockPos pos) throws MultiblockValidationException {
        Block block = world.func_180495_p(pos).func_177230_c();
        throw new MultiblockValidationException(Translator.translateToLocalFormatted("for.multiblock.error.invalid.interior", block.func_149732_F()));
    }

    @Override
    public BlockPos getReferenceCoord() {
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        return this.referenceCoord;
    }

    public int getNumConnectedBlocks() {
        return this.connectedParts.size();
    }

    @Override
    public void recalculateMinMaxCoords() {
        this.minimumCoord = new BlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
        this.maximumCoord = new BlockPos(Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MIN_VALUE);
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoords = part.getCoordinates();
            int minX = this.minimumCoord.func_177958_n();
            int minY = this.minimumCoord.func_177956_o();
            int minZ = this.minimumCoord.func_177952_p();
            int maxX = this.maximumCoord.func_177958_n();
            int maxY = this.maximumCoord.func_177956_o();
            int maxZ = this.maximumCoord.func_177952_p();
            if (partCoords.func_177958_n() < this.minimumCoord.func_177958_n()) {
                minX = partCoords.func_177958_n();
            }
            if (partCoords.func_177958_n() > this.maximumCoord.func_177958_n()) {
                maxX = partCoords.func_177958_n();
            }
            if (partCoords.func_177956_o() < this.minimumCoord.func_177956_o()) {
                minY = partCoords.func_177956_o();
            }
            if (partCoords.func_177956_o() > this.maximumCoord.func_177956_o()) {
                maxY = partCoords.func_177956_o();
            }
            if (partCoords.func_177952_p() < this.minimumCoord.func_177952_p()) {
                minZ = partCoords.func_177952_p();
            }
            if (partCoords.func_177952_p() > this.maximumCoord.func_177952_p()) {
                maxZ = partCoords.func_177952_p();
            }
            this.minimumCoord = new BlockPos(minX, minY, minZ);
            this.maximumCoord = new BlockPos(maxX, maxY, maxZ);
        }
    }

    protected BlockPos getMinimumCoord() {
        if (this.minimumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return new BlockPos((Vec3i)this.minimumCoord);
    }

    protected BlockPos getMaximumCoord() {
        if (this.maximumCoord == null) {
            this.recalculateMinMaxCoords();
        }
        return new BlockPos((Vec3i)this.maximumCoord);
    }

    protected final BlockPos getCenterCoord() {
        BlockPos minCoord = this.getMinimumCoord();
        BlockPos maxCoord = this.getMaximumCoord();
        return new BlockPos((minCoord.func_177958_n() + maxCoord.func_177958_n()) / 2, (minCoord.func_177956_o() + maxCoord.func_177956_o()) / 2, (minCoord.func_177952_p() + maxCoord.func_177952_p()) / 2);
    }

    protected final BlockPos getTopCenterCoord() {
        BlockPos minCoord = this.getMinimumCoord();
        BlockPos maxCoord = this.getMaximumCoord();
        return new BlockPos((minCoord.func_177958_n() + maxCoord.func_177958_n()) / 2, maxCoord.func_177956_o(), (minCoord.func_177952_p() + maxCoord.func_177952_p()) / 2);
    }

    protected final boolean isCoordInMultiblock(int x, int y, int z) {
        return x >= this.minimumCoord.func_177958_n() && x <= this.maximumCoord.func_177958_n() && y >= this.minimumCoord.func_177956_o() && y <= this.maximumCoord.func_177956_o() && z >= this.minimumCoord.func_177952_p() && z <= this.maximumCoord.func_177952_p();
    }

    @Override
    public boolean isEmpty() {
        return this.connectedParts.isEmpty();
    }

    @Override
    public boolean shouldConsume(IMultiblockControllerInternal otherController) {
        if (!otherController.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("Attempting to merge two multiblocks with different master classes - this should never happen!");
        }
        if (otherController == this) {
            return false;
        }
        int res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.warning("[%s] Encountered two controllers with the same reference coordinate. Auditing connected parts and retrying.", this.worldObj.field_72995_K ? "CLIENT" : "SERVER");
        this.auditParts();
        otherController.auditParts();
        res = this._shouldConsume(otherController);
        if (res < 0) {
            return true;
        }
        if (res > 0) {
            return false;
        }
        Log.error("My Controller (%d): size (%d), parts: %s", this.hashCode(), this.connectedParts.size(), this.getPartsListString());
        Log.error("Other Controller (%d): size (%d), coords: %s", otherController.hashCode(), otherController.getComponents().size(), otherController.getPartsListString());
        throw new IllegalArgumentException("[" + (this.worldObj.field_72995_K ? "CLIENT" : "SERVER") + "] " + "Two controllers with the same reference coord that somehow both have valid parts - this should never happen!");
    }

    private int _shouldConsume(IMultiblockControllerInternal otherController) {
        BlockPos myCoord = this.getReferenceCoord();
        BlockPos theirCoord = otherController.getReferenceCoord();
        if (theirCoord == null) {
            return -1;
        }
        return myCoord.compareTo((Vec3i)theirCoord);
    }

    @Override
    public String getPartsListString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IMultiblockComponent part : this.connectedParts) {
            if (!first) {
                sb.append(", ");
            }
            BlockPos partCoord = part.getCoordinates();
            sb.append(String.format("(%d: %d, %d, %d)", part.hashCode(), partCoord.func_177958_n(), partCoord.func_177956_o(), partCoord.func_177952_p()));
            first = false;
        }
        return sb.toString();
    }

    @Override
    public void auditParts() {
        HashSet<IMultiblockComponent> deadParts = new HashSet<IMultiblockComponent>();
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (!MultiblockControllerBase.isInvalid(part) && this.worldObj.func_175625_s(partCoord) == part) continue;
            this.onDetachBlock(part);
            deadParts.add(part);
        }
        this.connectedParts.removeAll(deadParts);
        Log.warning("[%s] Controller found %d dead parts during an audit, %d parts remain attached", this.worldObj.field_72995_K ? "CLIENT" : "SERVER", deadParts.size(), this.connectedParts.size());
    }

    @Override
    @Nonnull
    public Set<IMultiblockComponent> checkForDisconnections() {
        if (!this.shouldCheckForDisconnections) {
            return Collections.emptySet();
        }
        if (this.isEmpty()) {
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return Collections.emptySet();
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        this.referenceCoord = null;
        HashSet<IMultiblockComponent> deadParts = new HashSet<IMultiblockComponent>();
        IMultiblockComponent referencePart = null;
        int originalSize = this.connectedParts.size();
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (chunkProvider.func_186026_b(partCoord.func_177958_n() >> 4, partCoord.func_177952_p() >> 4) == null || MultiblockControllerBase.isInvalid(part)) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            if (this.worldObj.func_175625_s(partCoord) != part) {
                deadParts.add(part);
                this.onDetachBlock(part);
                continue;
            }
            MultiblockLogic logic = (MultiblockLogic)part.getMultiblockLogic();
            logic.setUnvisited();
            logic.forfeitMultiblockSaveDelegate();
            BlockPos c = part.getCoordinates();
            if (this.referenceCoord == null) {
                this.referenceCoord = c;
                referencePart = part;
                continue;
            }
            if (c.compareTo((Vec3i)this.referenceCoord) >= 0) continue;
            this.referenceCoord = c;
            referencePart = part;
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (referencePart == null || this.isEmpty()) {
            this.shouldCheckForDisconnections = false;
            MultiblockRegistry.addDeadController(this.worldObj, this);
            return Collections.emptySet();
        }
        MultiblockLogic logic = (MultiblockLogic)referencePart.getMultiblockLogic();
        logic.becomeMultiblockSaveDelegate();
        LinkedList<IMultiblockComponent> partsToCheck = new LinkedList<IMultiblockComponent>();
        partsToCheck.add(referencePart);
        while (!partsToCheck.isEmpty()) {
            IMultiblockComponent part = (IMultiblockComponent)partsToCheck.removeFirst();
            MultiblockLogic partLogic = (MultiblockLogic)part.getMultiblockLogic();
            partLogic.setVisited();
            List<IMultiblockComponent> nearbyParts = MultiblockUtil.getNeighboringParts(this.worldObj, part);
            for (IMultiblockComponent nearbyPart : nearbyParts) {
                MultiblockLogic nearbyPartLogic = (MultiblockLogic)nearbyPart.getMultiblockLogic();
                if (nearbyPartLogic.getController() != this || nearbyPartLogic.isVisited()) continue;
                nearbyPartLogic.setVisited();
                partsToCheck.add(nearbyPart);
            }
        }
        HashSet<IMultiblockComponent> removedParts = new HashSet<IMultiblockComponent>();
        for (IMultiblockComponent orphanCandidate : this.connectedParts) {
            MultiblockLogic logic2 = (MultiblockLogic)orphanCandidate.getMultiblockLogic();
            if (logic2.isVisited()) continue;
            deadParts.add(orphanCandidate);
            this.onDetachBlock(orphanCandidate);
            removedParts.add(orphanCandidate);
        }
        this.connectedParts.removeAll(deadParts);
        deadParts.clear();
        if (this.referenceCoord == null) {
            this.selectNewReferenceCoord();
        }
        this.shouldCheckForDisconnections = false;
        return removedParts;
    }

    @Override
    @Nonnull
    public Set<IMultiblockComponent> detachAllBlocks() {
        if (this.worldObj == null) {
            return new HashSet<IMultiblockComponent>();
        }
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (chunkProvider.func_186026_b(partCoord.func_177958_n() >> 4, partCoord.func_177952_p() >> 4) == null) continue;
            this.onDetachBlock(part);
        }
        HashSet<IMultiblockComponent> detachedParts = this.connectedParts;
        this.connectedParts = new HashSet();
        return detachedParts;
    }

    @Override
    public boolean isAssembled() {
        return this.assemblyState == AssemblyState.Assembled;
    }

    private void selectNewReferenceCoord() {
        IChunkProvider chunkProvider = this.worldObj.func_72863_F();
        IMultiblockComponent theChosenOne = null;
        this.referenceCoord = null;
        for (IMultiblockComponent part : this.connectedParts) {
            BlockPos partCoord = part.getCoordinates();
            if (MultiblockControllerBase.isInvalid(part) || chunkProvider.func_186026_b(partCoord.func_177958_n() >> 4, partCoord.func_177952_p() >> 4) == null || this.referenceCoord != null && this.referenceCoord.compareTo((Vec3i)partCoord) <= 0) continue;
            this.referenceCoord = part.getCoordinates();
            theChosenOne = part;
        }
        if (theChosenOne != null) {
            MultiblockLogic logic = (MultiblockLogic)theChosenOne.getMultiblockLogic();
            logic.becomeMultiblockSaveDelegate();
        }
    }

    private static boolean isInvalid(IMultiblockComponent part) {
        return part instanceof TileEntity && ((TileEntity)part).func_145837_r();
    }

    protected boolean onlyUpdateWhenAssembled() {
        return true;
    }

    protected static enum AssemblyState {
        Disassembled,
        Assembled,
        Paused;

    }
}

