/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenZebrawood
extends WorldGenTree {
    public WorldGenZebrawood(ITreeGenData tree) {
        super(tree, 8, 8);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        WorldGenHelper.generateSupportStems(wood, world, rand, startPos, this.height, this.girth, 0.8f, 0.3f);
        return WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, this.height - 4, 0), this.girth, 0.0f, 0.25f, 3, 2, 0.75f);
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, Set<BlockPos> branchEnds, BlockPos startPos) {
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, 1.0f + (float)this.girth, 2, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.9f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        while (leafSpawn > this.height - 4) {
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        }
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 1.9f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + rand.nextInt(Math.max(1, this.height - 10));
            if (rand.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + rand.nextInt(this.height / 2);
            }
            int x_off = -1 + rand.nextInt(3);
            int y_off = -1 + rand.nextInt(3);
            WorldGenHelper.generateSphere(world, startPos.func_177982_a(x_off, h, y_off), 1 + rand.nextInt(1), leaf, WorldGenHelper.EnumReplaceMode.AIR);
        }
    }
}

