/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenWenge
extends WorldGenTree {
    public WorldGenWenge(ITreeGenData tree) {
        super(tree, 6, 2);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        HashSet<BlockPos> branchEnds = new HashSet<BlockPos>();
        float branchSize = 3.0f;
        int branchHeight = this.height + 1;
        while (branchHeight > 1) {
            branchEnds.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, branchHeight, 0), this.girth, 0.2f, 0.2f, (int)branchSize, 2, 0.75f));
            --branchHeight;
            branchSize += 0.5f;
        }
        return branchEnds;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, Set<BlockPos> branchEnds, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.5f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        while (leafSpawn > 1) {
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 3.0f + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
            --leafSpawn;
        }
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCircle(world, rand, branchEnd, 3.0f, 3, 2, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.SOFT);
        }
    }
}

