/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenTeak
extends WorldGenTree {
    public WorldGenTeak(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        int branchWidth = this.height / 3;
        return WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, this.height - 3, 0), this.girth, 0.2f, 0.5f, branchWidth, 1, 1.0f);
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, Set<BlockPos> branchEnds, BlockPos startPos) {
        float leafMultiplier = (float)this.height / 6.0f;
        if (leafMultiplier > 2.0f) {
            leafMultiplier = 2.0f;
        }
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCircle(world, rand, branchEnd, 2.0f, Math.round(3.0f * leafMultiplier), 2, leaf, 1.0f, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.5f * leafMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.9f * leafMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.9f * leafMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        if (rand.nextBoolean()) {
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 1.9f * leafMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        }
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 0.5f * leafMultiplier + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
    }
}

