/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenIpe
extends WorldGenTree {
    public WorldGenIpe(ITreeGenData tree) {
        super(tree, 6, 4);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        float adjustedGirth = (float)this.girth * 0.65f;
        HashSet<BlockPos> branchCoords = new HashSet<BlockPos>();
        for (int trunkSpawn = this.height - 2; trunkSpawn > 2; trunkSpawn -= 2) {
            int radius = Math.round(adjustedGirth * (float)(this.height - trunkSpawn) / 1.5f);
            branchCoords.addAll(WorldGenHelper.generateBranches(world, rand, wood, startPos.func_177982_a(0, trunkSpawn, 0), this.girth, 0.25f, 0.25f, radius, 2, 1.0f));
        }
        return branchCoords;
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, Set<BlockPos> branchEnds, BlockPos startPos) {
        int leafSpawn = this.height + 1;
        float adjustedGirth = (float)this.girth * 0.65f;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 0.2f * adjustedGirth + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, 0.2f * adjustedGirth + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        for (BlockPos branchEnd : branchEnds) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, branchEnd, 2.0f + (float)this.girth, 2, WorldGenHelper.EnumReplaceMode.AIR);
        }
    }
}

