/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenCocobolo
extends WorldGenTree {
    public WorldGenCocobolo(ITreeGenData tree) {
        super(tree, 8, 8);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        return WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, Set<BlockPos> branchEnds, BlockPos startPos) {
        int leafSpawn = this.height;
        for (BlockPos treeTop : branchEnds) {
            WorldGenHelper.addBlock(world, treeTop.func_177982_a(0, 1, 0), leaf, WorldGenHelper.EnumReplaceMode.AIR);
        }
        int n = --leafSpawn;
        --leafSpawn;
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, n, 0), this.girth, 1 + this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        if (this.height > 10) {
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn--, 0), this.girth, 2 + this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        }
        WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(0, leafSpawn, 0), this.girth, this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        --leafSpawn;
        while (leafSpawn > 4) {
            int offset = 1;
            if (rand.nextBoolean()) {
                offset = -1;
            }
            float radius = leafSpawn % 2 == 0 ? (float)(2 + this.girth) : (float)this.girth;
            WorldGenHelper.generateCylinderFromTreeStartPos(world, leaf, startPos.func_177982_a(offset, leafSpawn, offset), this.girth, radius, 1, WorldGenHelper.EnumReplaceMode.AIR);
            --leafSpawn;
        }
    }
}

