/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenHelper;
import java.util.Collections;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenBalsa
extends WorldGenTree {
    public WorldGenBalsa(ITreeGenData tree) {
        super(tree, 6, 6);
    }

    @Override
    @Nonnull
    public Set<BlockPos> generateTrunk(World world, Random rand, TreeBlockTypeLog wood, BlockPos startPos) {
        WorldGenHelper.generateTreeTrunk(world, rand, wood, startPos, this.height, this.girth, 0, 0.0f, null, 0.0f);
        return Collections.emptySet();
    }

    @Override
    protected void generateLeaves(World world, Random rand, TreeBlockTypeLeaf leaf, Set<BlockPos> branchEnds, BlockPos startPos) {
        BlockPos.MutableBlockPos leafCenter = new BlockPos.MutableBlockPos(startPos.func_177982_a(0, this.height, 0));
        float leafRadius = ((float)this.girth - 1.0f) / 2.0f;
        WorldGenHelper.addBlock(world, (BlockPos)leafCenter, leaf, WorldGenHelper.EnumReplaceMode.AIR);
        leafCenter.func_185337_c(EnumFacing.DOWN);
        WorldGenHelper.generateCylinderFromPos(world, leaf, (BlockPos)leafCenter, leafRadius + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
        leafCenter.func_185337_c(EnumFacing.DOWN);
        if (this.height > 10) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, (BlockPos)leafCenter, leafRadius + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
            leafCenter.func_185337_c(EnumFacing.DOWN);
        }
        while (leafCenter.func_177956_o() > 6) {
            WorldGenHelper.generateCylinderFromPos(world, leaf, (BlockPos)leafCenter, leafRadius + (float)this.girth, 1, WorldGenHelper.EnumReplaceMode.SOFT);
            leafCenter.func_185337_c(EnumFacing.DOWN);
        }
    }
}

