/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics.alleles;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import forestry.apiculture.genetics.alleles.AlleleEffectThrottled;
import forestry.core.genetics.EffectData;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class AlleleEffectCreeper
extends AlleleEffectThrottled {
    private static final int explosionChance = 50;
    private static final byte defaultForce = 12;
    private static final byte indexExplosionTimer = 1;
    private static final byte indexExplosionForce = 2;

    public AlleleEffectCreeper() {
        super("creeper", true, 20, false, true);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (!(storedData instanceof EffectData)) {
            return new EffectData(3, 0);
        }
        if (((EffectData)storedData).getIntSize() < 3) {
            return new EffectData(3, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorldObj();
        BlockPos housingCoords = housing.getCoordinates();
        if (storedData.getInteger(1) > 0) {
            AlleleEffectCreeper.progressExplosion(storedData, world, housingCoords);
            return storedData;
        }
        List<EntityPlayer> players = AlleleEffectCreeper.getEntitiesInRange(genome, housing, EntityPlayer.class);
        for (EntityPlayer player : players) {
            int chance = 50;
            storedData.setInteger(2, 12);
            int count = BeeManager.armorApiaristHelper.wearsItems((EntityLivingBase)player, this.getUID(), true);
            if (count > 3) continue;
            if (count > 2) {
                chance = 5;
                storedData.setInteger(2, 6);
            } else if (count > 1) {
                chance = 20;
                storedData.setInteger(2, 8);
            } else if (count > 0) {
                chance = 35;
                storedData.setInteger(2, 10);
            }
            if (world.field_73012_v.nextInt(1000) >= chance) continue;
            float pitch = (1.0f + (world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.2f) * 0.7f;
            world.func_184148_a((EntityPlayer)null, (double)housingCoords.func_177958_n(), (double)housingCoords.func_177956_o(), (double)housingCoords.func_177952_p(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 4.0f, pitch);
            storedData.setInteger(1, 2);
        }
        return storedData;
    }

    private static void progressExplosion(IEffectData storedData, World world, BlockPos pos) {
        int explosionTimer = storedData.getInteger(1);
        storedData.setInteger(1, --explosionTimer);
        if (explosionTimer > 0) {
            return;
        }
        world.func_72876_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (float)storedData.getInteger(2), false);
    }
}

