/*
 * Decompiled with CFR 0.152.
 */
package forestry.api.multiblock;

import forestry.api.multiblock.IMultiblockComponent;
import forestry.api.multiblock.IMultiblockController;
import forestry.api.multiblock.IMultiblockLogic;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public abstract class MultiblockTileEntityBase<T extends IMultiblockLogic>
extends TileEntity
implements IMultiblockComponent {
    private final T multiblockLogic;

    public MultiblockTileEntityBase(T multiblockLogic) {
        this.multiblockLogic = multiblockLogic;
    }

    @Override
    public BlockPos getCoordinates() {
        return this.func_174877_v();
    }

    public T getMultiblockLogic() {
        return this.multiblockLogic;
    }

    @Override
    public abstract void onMachineAssembled(IMultiblockController var1, BlockPos var2, BlockPos var3);

    @Override
    public abstract void onMachineBroken();

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.multiblockLogic.readFromNBT(data);
    }

    public void func_145841_b(NBTTagCompound data) {
        super.func_145841_b(data);
        this.multiblockLogic.writeToNBT(data);
    }

    public final void func_145843_s() {
        super.func_145843_s();
        this.multiblockLogic.invalidate(this.field_145850_b, this);
    }

    public final void onChunkUnload() {
        super.onChunkUnload();
        this.multiblockLogic.onChunkUnload(this.field_145850_b, this);
    }

    public final void func_145829_t() {
        super.func_145829_t();
        this.multiblockLogic.validate(this.field_145850_b, this);
    }

    public final Packet func_145844_m() {
        NBTTagCompound packetData = new NBTTagCompound();
        this.multiblockLogic.encodeDescriptionPacket(packetData);
        this.encodeDescriptionPacket(packetData);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, packetData);
    }

    public final void onDataPacket(NetworkManager network, SPacketUpdateTileEntity packet) {
        NBTTagCompound nbtData = packet.func_148857_g();
        this.multiblockLogic.decodeDescriptionPacket(nbtData);
        this.decodeDescriptionPacket(nbtData);
    }

    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
    }

    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
    }
}

