/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology;

import forestry.api.arboriculture.ILeafTickHandler;
import forestry.api.arboriculture.ITree;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.utils.Log;
import forestry.lepidopterology.PluginLepidopterology;
import forestry.lepidopterology.entities.EntityButterfly;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ButterflySpawner
implements ILeafTickHandler {
    @Override
    public boolean onRandomLeafTick(ITree tree, World world, BlockPos pos, boolean isDestroyed) {
        if (world.field_73012_v.nextFloat() >= tree.getGenome().getSappiness() * tree.getGenome().getYield()) {
            return false;
        }
        IButterfly spawn = ButterflyManager.butterflyRoot.getIndividualTemplates().get(world.field_73012_v.nextInt(ButterflyManager.butterflyRoot.getIndividualTemplates().size()));
        float rarity = PluginLepidopterology.spawnRaritys.containsKey(spawn.getGenome().getPrimary().getUID()) ? spawn.getGenome().getPrimary().getRarity() : PluginLepidopterology.spawnRaritys.get(spawn.getGenome().getPrimary().getUID()).floatValue();
        if (world.field_73012_v.nextFloat() >= rarity * 0.5f) {
            return false;
        }
        if (world.func_72907_a(EntityButterfly.class) > PluginLepidopterology.spawnConstraint) {
            return false;
        }
        if (!spawn.canSpawn(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p())) {
            return false;
        }
        if (world.func_175623_d(pos.func_177978_c())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.func_177978_c());
        } else if (world.func_175623_d(pos.func_177968_d())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.func_177968_d());
        } else if (world.func_175623_d(pos.func_177976_e())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.func_177976_e());
        } else if (world.func_175623_d(pos.func_177974_f())) {
            ButterflySpawner.attemptButterflySpawn(world, spawn, pos.func_177974_f());
        }
        return false;
    }

    private static void attemptButterflySpawn(World world, IButterfly butterfly, BlockPos pos) {
        if (ButterflyManager.butterflyRoot.spawnButterflyInWorld(world, butterfly.copy(), pos.func_177958_n(), (float)pos.func_177956_o() + 0.1f, pos.func_177952_p()) != null) {
            Log.trace("Spawned a butterfly '%s' at %s/%s/%s.", butterfly.getDisplayName(), pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
    }
}

