/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.blocks;

import forestry.api.core.IItemModelRegister;
import forestry.api.core.IModelManager;
import forestry.core.blocks.IBlockWithMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.IGrowable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenBigMushroom;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMushroom
extends BlockBush
implements IItemModelRegister,
IGrowable,
IBlockWithMeta {
    public static final PropertyEnum<MushroomType> MUSHROOM = PropertyEnum.func_177709_a((String)"mushroom", MushroomType.class);
    private final WorldGenerator[] generators;
    private final ItemStack[] drops;

    public BlockMushroom() {
        this.func_149711_c(0.0f);
        this.generators = new WorldGenerator[]{new WorldGenBigMushroom(Blocks.field_150420_aW), new WorldGenBigMushroom(Blocks.field_150419_aX)};
        this.drops = new ItemStack[]{new ItemStack((Block)Blocks.field_150338_P), new ItemStack((Block)Blocks.field_150337_Q)};
        this.func_149647_a(null);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(MUSHROOM, (Comparable)((Object)MushroomType.BROWN)));
        this.func_149675_a(true);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{MUSHROOM});
    }

    public int func_176201_c(IBlockState state) {
        return ((MushroomType)((Object)state.func_177229_b(MUSHROOM))).ordinal();
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(MUSHROOM, (Comparable)((Object)MushroomType.values()[meta]));
    }

    public boolean func_149653_t() {
        return true;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        MushroomType type = BlockMushroom.getTypeFromMeta(state.func_177230_c().func_176201_c(state));
        ret.add(this.drops[type.ordinal()]);
        return ret;
    }

    public boolean func_176196_c(World worldIn, BlockPos pos) {
        return super.func_176196_c(worldIn, pos) && this.func_180671_f(worldIn, pos, this.func_176223_P());
    }

    protected boolean func_185514_i(IBlockState state) {
        return state.func_185913_b();
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        if (pos.func_177956_o() >= 0 && pos.func_177956_o() < 256) {
            IBlockState iblockstate = worldIn.func_180495_p(pos.func_177977_b());
            return iblockstate.func_177230_c() == Blocks.field_150391_bh || iblockstate.func_177230_c() == Blocks.field_150346_d && iblockstate.func_177229_b((IProperty)BlockDirt.field_176386_a) == BlockDirt.DirtType.PODZOL || worldIn.func_175699_k(pos) < 13 && iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        return false;
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        int meta = block.func_176201_c(blockState);
        MushroomType type = BlockMushroom.getTypeFromMeta(meta);
        int maturity = meta >> 2;
        this.tickGermling(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), rand, type, maturity);
    }

    private void tickGermling(World world, int i, int j, int k, Random random, MushroomType type, int maturity) {
        int lightvalue = world.func_175699_k(new BlockPos(i, j + 1, k));
        if (random.nextInt(2) != 0) {
            return;
        }
        if (maturity != 3) {
            maturity = 3;
            int matX = maturity << 2;
            int meta = matX | type.ordinal();
            world.func_180501_a(new BlockPos(i, j, k), world.func_180495_p(new BlockPos(i, j, k)).func_177230_c().func_176203_a(meta), 2);
        } else if (lightvalue <= 7) {
            this.generateTree(world, new BlockPos(i, j, k), world.func_180495_p(new BlockPos(i, j, k)), random);
        }
    }

    public void generateTree(World world, BlockPos pos, IBlockState state, Random rand) {
        MushroomType type = (MushroomType)((Object)state.func_177229_b(MUSHROOM));
        world.func_175698_g(pos);
        if (!this.generators[type.ordinal()].func_180709_b(world, rand, pos)) {
            world.func_180501_a(pos, this.func_176203_a(type.ordinal()), 0);
        }
    }

    public void grow(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.generateTree(worldIn, pos, state, rand);
    }

    public static MushroomType getTypeFromMeta(int meta) {
        return MushroomType.values()[meta %= MushroomType.values().length];
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        list.add(new ItemStack(item, 1, 0));
        list.add(new ItemStack(item, 1, 1));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, 0, "minecraft", "brown_mushroom");
        manager.registerItemModel(item, 1, "minecraft", "red_mushroom");
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return true;
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return (double)worldIn.field_73012_v.nextFloat() < 0.45;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state, rand);
    }

    @Override
    public String getNameFromMeta(int meta) {
        MushroomType type = BlockMushroom.getTypeFromMeta(meta);
        return type.func_176610_l();
    }

    public static enum MushroomType implements IStringSerializable
    {
        BROWN,
        RED;


        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }
}

