/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.worldgen;

import forestry.arboriculture.worldgen.ITreeBlockType;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class WorldGenBase
extends WorldGenerator {
    public final boolean func_180709_b(World world, Random random, BlockPos pos) {
        return this.generate(world, pos, false);
    }

    public boolean generate(World world, BlockPos pos, boolean forced) {
        return false;
    }

    protected abstract boolean addBlock(World var1, BlockPos var2, ITreeBlockType var3, EnumReplaceMode var4);

    protected final void generateCuboid(World world, Vector start, Vector area, ITreeBlockType block, EnumReplaceMode replace) {
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    this.addBlock(world, new BlockPos(x, y, z), block, replace);
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCylinder(World world, Vector center, float radius, int height, ITreeBlockType block, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector position = new Vector(x, y, z);
                    Vector treeCenter = new Vector(center.x, y, center.z);
                    if (Vector.distance(position, treeCenter) <= (double)radius + 0.01) {
                        EnumFacing direction = Vector.direction(position, treeCenter);
                        block.setDirection(direction);
                        this.addBlock(world, new BlockPos(x, y, z), block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateCircle(World world, Vector center, float radius, int width, int height, ITreeBlockType block, EnumReplaceMode replace) {
        this.generateCircle(world, center, radius, width, height, block, 1.0f, replace);
    }

    protected final void generateCircle(World world, Vector center, float radius, int width, int height, ITreeBlockType block, float chance, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - radius, center.y, center.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    double distance;
                    if (!(world.field_73012_v.nextFloat() > chance) && (double)(radius - (float)width) - 0.01 < (distance = Vector.distance(new Vector(x, y, z), new Vector(center.x, y, center.z))) && distance <= (double)radius + 0.01) {
                        this.addBlock(world, new BlockPos(x, y, z), block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected final void generateSphere(World world, Vector center, int radius, ITreeBlockType block, EnumReplaceMode replace) {
        Vector start = new Vector(center.x - (float)radius, center.y - (float)radius, center.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center.x, center.y, center.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(world, new BlockPos(x, y, z), block, replace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static class Vector {
        public final float x;
        public final float y;
        public final float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }

        public static EnumFacing direction(Vector a, Vector b) {
            int z;
            int y;
            int x = (int)Math.abs(a.x - b.x);
            int max = Math.max(x, Math.max(y = (int)Math.abs(a.y - b.y), z = (int)Math.abs(a.z - b.z)));
            if (max == x) {
                return EnumFacing.EAST;
            }
            if (max == z) {
                return EnumFacing.SOUTH;
            }
            return EnumFacing.UP;
        }
    }

    protected static enum EnumReplaceMode {
        AIR{

            @Override
            public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
                return world.func_175623_d(pos);
            }
        }
        ,
        ALL{

            @Override
            public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
                return true;
            }
        }
        ,
        SOFT{

            @Override
            public boolean canReplace(IBlockState blockState, World world, BlockPos pos) {
                return blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos);
            }
        };


        public abstract boolean canReplace(IBlockState var1, World var2, BlockPos var3);
    }
}

