/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenZebrawood
extends WorldGenTree {
    public WorldGenZebrawood(ITreeGenData tree) {
        super(tree, 8, 8);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        this.generateSupportStems(world, this.height, this.girth, 0.8f, 0.3f);
        List<BlockPos> branchCoords = this.generateBranches(world, this.height - 4, 0, 0, 0.0f, 0.25f, 3, 2, 0.75f);
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd, 1.0f, 2, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        while (leafSpawn > this.height - 4) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.5f, 1, this.leaf);
        }
        this.generateAdjustedCylinder(world, leafSpawn, 1.9f, 1, this.leaf);
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + world.field_73012_v.nextInt(Math.max(1, this.height - 10));
            if (world.field_73012_v.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + world.field_73012_v.nextInt(this.height / 2);
            }
            int x_off = -1 + world.field_73012_v.nextInt(3);
            int y_off = -1 + world.field_73012_v.nextInt(3);
            this.generateSphere(world, new WorldGenBase.Vector(x_off, h, y_off), 1 + world.field_73012_v.nextInt(1), this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

