/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.arboriculture.worldgen.TreeBlockTypeLog;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class WorldGenTree
extends WorldGenArboriculture {
    private static final int minHeight = 4;
    private static final int maxHeight = 80;
    private final int baseHeight;
    private final int heightVariation;
    protected int girth;
    protected int height;

    protected WorldGenTree(ITreeGenData tree, int baseHeight, int heightVariation) {
        super(tree);
        this.baseHeight = baseHeight;
        this.heightVariation = heightVariation;
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }

    protected WorldGenBase.Vector getCenteredAt(int yCenter, int xOffset, int zOffset) {
        float cent = this.girth % 2 == 0 ? 0.5f : 0.0f;
        return new WorldGenBase.Vector(cent + (float)xOffset, yCenter, cent + (float)zOffset);
    }

    protected WorldGenBase.Vector getCenteredAt(BlockPos centerPos) {
        float cent = this.girth % 2 == 0 ? 0.5f : 0.0f;
        return new WorldGenBase.Vector(cent + (float)centerPos.func_177958_n(), centerPos.func_177956_o(), cent + (float)centerPos.func_177952_p());
    }

    protected void generateAdjustedCylinder(World world, int yCenter, float radius, int height, ITreeBlockType block) {
        this.generateAdjustedCylinder(world, yCenter, 0, 0, radius, height, block, WorldGenBase.EnumReplaceMode.SOFT);
    }

    protected void generateAdjustedCylinder(World world, int yCenter, float radius, int height, ITreeBlockType block, WorldGenBase.EnumReplaceMode replace) {
        this.generateAdjustedCylinder(world, yCenter, 0, 0, radius, height, block, replace);
    }

    protected void generateAdjustedCylinder(World world, int yCenter, int xOffset, int zOffset, float radius, int height, ITreeBlockType block, WorldGenBase.EnumReplaceMode replace) {
        WorldGenBase.Vector center = this.getCenteredAt(yCenter, xOffset, zOffset);
        this.generateCylinder(world, center, radius + (float)this.girth, height, block, replace);
    }

    protected void generateAdjustedCylinder(World world, BlockPos centerPos, float radius, int height, ITreeBlockType block, WorldGenBase.EnumReplaceMode replace) {
        WorldGenBase.Vector center = this.getCenteredAt(centerPos);
        this.generateCylinder(world, center, radius + (float)this.girth, height, block, replace);
    }

    protected void generateAdjustedCircle(World world, int yCenter, int xOffset, int zOffset, float radius, int width, int height, ITreeBlockType block, float chance, WorldGenBase.EnumReplaceMode replace) {
        WorldGenBase.Vector center = this.getCenteredAt(yCenter, xOffset, zOffset);
        this.generateCircle(world, center, radius, width, height, block, chance, replace);
    }

    protected void generateAdjustedCircle(World world, BlockPos centerPos, float radius, int width, int height, ITreeBlockType block, float chance, WorldGenBase.EnumReplaceMode replace) {
        WorldGenBase.Vector center = this.getCenteredAt(centerPos);
        this.generateCircle(world, center, radius, width, height, block, chance, replace);
    }

    @Override
    public boolean canGrow(World world, BlockPos pos) {
        return this.tree.canGrow(world, pos, this.girth, this.height);
    }

    @Override
    public final void preGenerate(World world, BlockPos startPos) {
        super.preGenerate(world, startPos);
        this.height = this.determineHeight(world, this.baseHeight, this.heightVariation);
        this.girth = this.tree.getGirth(world, startPos);
    }

    protected int modifyByHeight(World world, int val, int min, int max) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int determined = Math.round((float)val * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return determined < min ? min : (determined > max ? max : determined);
    }

    private int determineHeight(World world, int required, int variation) {
        ITreekeepingMode treeModifier = TreeManager.treeRoot.getTreekeepingMode(world);
        int baseHeight = required + world.field_73012_v.nextInt(variation);
        int height = Math.round((float)baseHeight * this.tree.getHeightModifier() * treeModifier.getHeightModifier(this.tree.getGenome(), 1.0f));
        return height < 4 ? 4 : (height > 80 ? 80 : height);
    }

    @Override
    public TreeBlockTypeLeaf getLeaf(GameProfile owner) {
        return new TreeBlockTypeLeaf(owner);
    }

    @Override
    public ITreeBlockType getWood() {
        return new TreeBlockTypeLog();
    }
}

