/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenTeak
extends WorldGenTree {
    public WorldGenTeak(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        float leafMultiplier = (float)this.height / 6.0f;
        if (leafMultiplier > 2.0f) {
            leafMultiplier = 2.0f;
        }
        int branchWidth = this.height / 3;
        List<BlockPos> branchCoords = this.generateBranches(world, this.height - 3, 0, 0, 0.2f, 0.5f, branchWidth, 1);
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCircle(world, branchEnd, 2.0f, Math.round(3.0f * leafMultiplier), 2, this.leaf, 1.0f, WorldGenBase.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f * leafMultiplier, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f * leafMultiplier, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f * leafMultiplier, 1, this.leaf);
        if (world.field_73012_v.nextBoolean()) {
            this.generateAdjustedCylinder(world, leafSpawn--, 1.9f * leafMultiplier, 1, this.leaf);
        }
        this.generateAdjustedCylinder(world, leafSpawn, 0.5f * leafMultiplier, 1, this.leaf);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

