/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenSpruce
extends WorldGenTree {
    public WorldGenSpruce(ITreeGenData tree) {
        super(tree, 5, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
        int branchWidth = this.height / 4;
        while (leafSpawn > 2) {
            int leafRadius = Math.min(4, branchWidth);
            List<BlockPos> branchCoords = this.generateBranches(world, leafSpawn, 0, 0, 0.2f, 0.5f, branchWidth, 1);
            for (BlockPos branchEnd : branchCoords) {
                this.generateAdjustedCircle(world, branchEnd, leafRadius, 3, 2, this.leaf, 1.0f, WorldGenBase.EnumReplaceMode.SOFT);
            }
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
            this.generateAdjustedCylinder(world, leafSpawn--, 1.0f, 1, this.leaf);
            ++branchWidth;
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

