/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenSilverLime
extends WorldGenTree {
    public WorldGenSilverLime(ITreeGenData tree) {
        super(tree, 6, 4);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        List<BlockPos> branchCoords = this.generateBranches(world, 3 + world.field_73012_v.nextInt(1), 0, 0, 0.25f, 0.1f, Math.round((float)this.height * 0.25f), 2, 0.5f);
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd, 0.0f, 1, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        float radius = 1.0f;
        while (leafSpawn > 1) {
            this.generateAdjustedCylinder(world, leafSpawn--, radius, 1, this.leaf);
            radius = (float)((double)radius + 0.25);
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

