/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.world.World;

public class WorldGenPlum
extends WorldGenTree {
    public WorldGenPlum(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 2 ? yCenter : 3;
        WorldGenBase.Vector center = this.getCenteredAt(yCenter, 0, 0);
        int radius = Math.round((float)(2 + world.field_73012_v.nextInt(this.girth)) * ((float)this.height / 4.0f));
        if (radius > 4) {
            radius = 4;
        }
        this.generateSphere(world, center, radius, this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

