/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenPapaya
extends WorldGenTree {
    public WorldGenPapaya(ITreeGenData tree) {
        super(tree, 7, 2);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        List<BlockPos> branchCoords = this.generateBranches(world, this.height, 0, 0, 0.15f, 0.25f, this.height / 4, 1, 0.25f);
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd, 1.0f, 1, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        this.generateSphere(world, this.getCenteredAt(yCenter, 0, 0), Math.round((float)(2 + world.field_73012_v.nextInt(this.girth)) * ((float)this.height / 8.0f)), this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

