/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenMahogany
extends WorldGenTree {
    public WorldGenMahogany(ITreeGenData tree) {
        super(tree, 12, 6);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth, 0.6f);
        this.generateSupportStems(world, this.height, this.girth, 0.4f, 0.4f);
        ArrayList<BlockPos> branchCoords = new ArrayList<BlockPos>();
        for (int yBranch = this.height - 4; yBranch < this.height - 2; ++yBranch) {
            branchCoords.addAll(this.generateBranches(world, yBranch, 0, 0, 0.15f, 0.25f, Math.round((float)(this.height - yBranch) * 0.5f), 1, 0.25f));
        }
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd, 2.0f, 2, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 3.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 3.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

