/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenMahoe
extends WorldGenTree {
    public WorldGenMahoe(ITreeGenData tree) {
        super(tree, 6, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        ArrayList<BlockPos> branchCoords = new ArrayList<BlockPos>();
        for (int yBranch = 2; yBranch < this.height - 1; ++yBranch) {
            branchCoords.addAll(this.generateBranches(world, yBranch, 0, 0, 0.15f, 0.25f, Math.round((float)(this.height - yBranch) * 0.75f), 1, 0.25f));
        }
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd, 2.0f, 2, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        int yCenter = this.height - this.girth;
        yCenter = yCenter > 3 ? yCenter : 4;
        this.generateSphere(world, this.getCenteredAt(yCenter, 0, 0), 3 + world.field_73012_v.nextInt(this.girth), this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

