/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import net.minecraft.world.World;

public class WorldGenLarch
extends WorldGenTree {
    public WorldGenLarch(ITreeGenData tree) {
        super(tree, 6, 5);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        float sizeMultiplier = Math.max((float)(this.height / 8), 1.0f);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, sizeMultiplier, 1, this.leaf);
        while (leafSpawn > 2) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f * sizeMultiplier, 1, this.leaf);
            this.generateAdjustedCylinder(world, leafSpawn--, sizeMultiplier, 1, this.leaf);
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

