/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenKapok
extends WorldGenTree {
    public WorldGenKapok(ITreeGenData tree) {
        super(tree, 10, 8);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth, 0.6f);
        this.generateSupportStems(world, this.height, this.girth, 0.8f, 0.4f);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f, 1, this.leaf);
        ArrayList<BlockPos> branchCoords = new ArrayList<BlockPos>();
        while (leafSpawn > this.height - 4) {
            int radius = Math.round((float)(this.girth * (this.height - leafSpawn)) / 1.5f) + 6;
            branchCoords.addAll(this.generateBranches(world, leafSpawn, 0, 0, 0.3f, 0.25f, radius, 6));
            leafSpawn -= 2;
        }
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd.func_177956_o() + 1, branchEnd.func_177958_n(), branchEnd.func_177952_p(), 2.0f, 2, this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        for (int times = 0; times < this.height / 4; ++times) {
            int h = 10 + world.field_73012_v.nextInt(Math.max(1, this.height - 10));
            if (world.field_73012_v.nextBoolean() && h < this.height / 2) {
                h = this.height / 2 + world.field_73012_v.nextInt(this.height / 2);
            }
            int x_off = -1 + world.field_73012_v.nextInt(3);
            int y_off = -1 + world.field_73012_v.nextInt(3);
            this.generateSphere(world, new WorldGenBase.Vector(x_off, h, y_off), 1 + world.field_73012_v.nextInt(1), this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

