/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTreeVanilla;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenJungle
extends WorldGenTreeVanilla {
    public WorldGenJungle(ITreeGenData tree) {
        super(tree);
    }

    @Override
    public void generate(World world) {
        float vinesChance = 0.0f;
        if (this.girth >= 2) {
            this.height = (int)((float)this.height * 1.5f);
            vinesChance = 0.8f;
        }
        this.generateTreeTrunk(world, this.height, this.girth, vinesChance);
        if (this.height > 10) {
            ArrayList<BlockPos> branchCoords = new ArrayList<BlockPos>();
            for (int branchSpawn = 6; branchSpawn < this.height - 2; branchSpawn += world.field_73012_v.nextInt(4)) {
                branchCoords.addAll(this.generateBranches(world, branchSpawn, 0, 0, 0.5f, 0.0f, 2, 1, 0.25f));
            }
            for (BlockPos branchEnd : branchCoords) {
                this.generateAdjustedCylinder(world, branchEnd, 0.0f, 1, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
            }
        }
        int leafSpawn = this.height + 1;
        float canopyRadiusMultiplier = (float)this.height / 7.0f;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f * canopyRadiusMultiplier, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 1.9f * canopyRadiusMultiplier, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn, 1.9f * canopyRadiusMultiplier, 1, this.leaf);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

