/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenIpe
extends WorldGenTree {
    public WorldGenIpe(ITreeGenData tree) {
        super(tree, 6, 4);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        float adjustedGirth = (float)this.girth * 0.65f;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.2f * adjustedGirth, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.2f * adjustedGirth, 1, this.leaf);
        ArrayList<BlockPos> branchCoords = new ArrayList<BlockPos>();
        while (leafSpawn > 2) {
            int radius = Math.round(adjustedGirth * (float)(this.height - leafSpawn) / 1.5f);
            branchCoords.addAll(this.generateBranches(world, leafSpawn, 0, 0, 0.25f, 0.25f, radius, 2));
            leafSpawn -= 2;
        }
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd, 2.0f, 2, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

