/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenChestnut
extends WorldGenTree {
    public WorldGenChestnut(ITreeGenData tree) {
        super(tree, 7, 3);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateAdjustedCylinder(world, leafSpawn--, 0.0f, 1, this.leaf);
        this.generateAdjustedCylinder(world, leafSpawn--, 0.5f, 1, this.leaf);
        while (leafSpawn > 4) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        }
        if (world.field_73012_v.nextBoolean()) {
            this.generateAdjustedCylinder(world, leafSpawn--, 2.0f, 1, this.leaf);
        }
        int branchRadius = this.height / 2;
        List<BlockPos> branchCoords = this.generateBranches(world, leafSpawn, 0, 0, 0.5f, 0.5f, branchRadius, 2);
        for (BlockPos branchEnd : branchCoords) {
            this.generateAdjustedCylinder(world, branchEnd, 1.0f, 2, (ITreeBlockType)this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        this.generateAdjustedCylinder(world, leafSpawn, 1.5f, 1, this.leaf);
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

