/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenBalsa
extends WorldGenTree {
    public WorldGenBalsa(ITreeGenData tree) {
        super(tree, 6, 6);
    }

    @Override
    public void generate(World world) {
        this.generateTreeTrunk(world, this.height, this.girth);
        int leafSpawn = this.height;
        float leafRadius = ((float)this.girth - 1.0f) / 2.0f;
        this.addLeaf(world, new BlockPos(0, leafSpawn--, 0), WorldGenBase.EnumReplaceMode.AIR);
        this.generateAdjustedCylinder(world, leafSpawn--, leafRadius, 1, this.leaf);
        if (this.height > 10) {
            this.generateAdjustedCylinder(world, leafSpawn--, leafRadius, 1, this.leaf);
        }
        --leafSpawn;
        while (leafSpawn > 6) {
            this.generateAdjustedCylinder(world, leafSpawn, leafRadius, 1, this.leaf);
            --leafSpawn;
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

