/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import com.mojang.authlib.GameProfile;
import forestry.api.world.ITreeGenData;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.ITreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockType;
import forestry.arboriculture.worldgen.TreeBlockTypeLeaf;
import forestry.core.tiles.TileUtil;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public abstract class WorldGenArboriculture
extends WorldGenBase {
    private static final ITreeBlockType vineNorth = new TreeBlockType(Blocks.field_150395_bd, 1);
    private static final ITreeBlockType vineSouth = new TreeBlockType(Blocks.field_150395_bd, 4);
    private static final ITreeBlockType vineWest = new TreeBlockType(Blocks.field_150395_bd, 8);
    private static final ITreeBlockType vineEast = new TreeBlockType(Blocks.field_150395_bd, 2);
    private static final int minPodHeight = 3;
    protected final ITreeGenData tree;
    private BlockPos startPos;
    protected TreeBlockTypeLeaf leaf;
    protected ITreeBlockType wood;

    protected WorldGenArboriculture(ITreeGenData tree) {
        this.tree = tree;
    }

    @Override
    public boolean generate(World world, BlockPos pos, boolean forced) {
        this.leaf = this.getLeaf(WorldGenArboriculture.getOwner(world, pos));
        this.wood = this.getWood();
        this.preGenerate(world, pos);
        if (forced || this.canGrow(world, pos)) {
            this.generate(world);
            return true;
        }
        return false;
    }

    private static GameProfile getOwner(World world, BlockPos pos) {
        TileTreeContainer tile = TileUtil.getTile((IBlockAccess)world, pos, TileTreeContainer.class);
        if (tile == null) {
            return null;
        }
        return tile.getOwner();
    }

    public void preGenerate(World world, BlockPos startPos) {
        this.startPos = startPos;
    }

    protected abstract void generate(World var1);

    public abstract boolean canGrow(World var1, BlockPos var2);

    protected abstract TreeBlockTypeLeaf getLeaf(GameProfile var1);

    protected abstract ITreeBlockType getWood();

    protected List<BlockPos> generateTreeTrunk(World world, int height, int girth) {
        return this.generateTreeTrunk(world, height, girth, 0.0f);
    }

    protected List<BlockPos> generateTreeTrunk(World world, int height, int girth, float vinesChance) {
        return this.generateTreeTrunk(world, height, girth, vinesChance, null, 0.0f);
    }

    protected List<BlockPos> generateTreeTrunk(World world, int height, int girth, float vinesChance, EnumFacing leanDirection, float leanAmount) {
        return this.generateTreeTrunk(world, height, girth, 0, vinesChance, leanDirection, leanAmount);
    }

    protected List<BlockPos> generateTreeTrunk(World world, int height, int girth, int yStart, float vinesChance, EnumFacing leanDirection, float leanAmount) {
        ArrayList<BlockPos> treeTops = new ArrayList<BlockPos>();
        int leanStartY = (int)Math.floor((float)height * 0.33f);
        int prevXOffset = 0;
        int prevZOffset = 0;
        int offsetX = 0;
        int offsetZ = 0;
        if (leanDirection != null) {
            offsetX = leanDirection.func_82601_c();
            offsetZ = leanDirection.func_82599_e();
        }
        int offset = (girth - 1) / 2;
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                for (int y = yStart; y < height; ++y) {
                    float lean = y < leanStartY ? 0.0f : leanAmount * (float)(y - leanStartY) / (float)(height - leanStartY);
                    int xOffset = (int)Math.floor((float)offsetX * lean - (float)offset);
                    int zOffset = (int)Math.floor((float)offsetZ * lean - (float)offset);
                    if (xOffset != prevXOffset || zOffset != prevZOffset) {
                        prevXOffset = xOffset;
                        prevZOffset = zOffset;
                        if (y > 0) {
                            this.wood.setDirection(leanDirection);
                            this.addWood(world, new BlockPos(x + xOffset, y - 1, z + zOffset), WorldGenBase.EnumReplaceMode.ALL);
                            this.wood.setDirection(EnumFacing.UP);
                        }
                    }
                    this.addWood(world, new BlockPos(x + xOffset, y, z + zOffset), WorldGenBase.EnumReplaceMode.ALL);
                    this.addVines(world, new BlockPos(x + xOffset, y, z + zOffset), vinesChance);
                    if (y + 1 != height) continue;
                    treeTops.add(new BlockPos(x + xOffset, y, z + zOffset));
                }
            }
        }
        return treeTops;
    }

    public boolean hasPods() {
        return this.tree.allowsFruitBlocks();
    }

    protected void generatePods(World world, int height, int girth) {
        for (int y = 3; y < height; ++y) {
            for (int x = 0; x < girth; ++x) {
                for (int z = 0; z < girth; ++z) {
                    if (x > 0 && x < girth && z > 0 && z < girth) continue;
                    this.trySpawnFruitBlock(world, new BlockPos(x + 1, y, z));
                    this.trySpawnFruitBlock(world, new BlockPos(x - 1, y, z));
                    this.trySpawnFruitBlock(world, new BlockPos(x, y, z + 1));
                    this.trySpawnFruitBlock(world, new BlockPos(x, y, z - 1));
                }
            }
        }
    }

    private void trySpawnFruitBlock(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos = pos.func_177971_a((Vec3i)this.startPos));
        Block block = blockState.func_177230_c();
        if (block.func_176200_f((IBlockAccess)world, pos) && !block.isLeaves(blockState, (IBlockAccess)world, pos)) {
            this.tree.trySpawnFruitBlock(world, pos);
        }
    }

    protected void generateSupportStems(World world, int height, int girth, float chance, float maxHeight) {
        int offset = (int)Math.ceil((float)girth / 2.0f);
        int max = (int)Math.floor((float)girth / 2.0f) + offset;
        if (girth % 2 == 0) {
            ++max;
        }
        for (int x = -offset; x < max; ++x) {
            for (int z = -offset; z < max; ++z) {
                if (x == -offset && z == -offset || x == max && z == max || x == -offset && z == max || x == max && z == -offset) continue;
                int stemHeight = world.field_73012_v.nextInt(Math.round((float)height * maxHeight));
                if (!(world.field_73012_v.nextFloat() < chance)) continue;
                for (int i = 0; i < stemHeight; ++i) {
                    this.addWood(world, new BlockPos(x, i, z), WorldGenBase.EnumReplaceMode.SOFT);
                }
            }
        }
    }

    protected List<BlockPos> generateBranches(World world, int startY, int xOffset, int zOffset, float spreadY, float spreadXZ, int radius, int count) {
        return this.generateBranches(world, startY, xOffset, zOffset, spreadY, spreadXZ, radius, count, 1.0f);
    }

    protected List<BlockPos> generateBranches(World world, int startY, int xOffset, int zOffset, float spreadY, float spreadXZ, int radius, int count, float chance) {
        ArrayList<BlockPos> branchEnds = new ArrayList<BlockPos>();
        if (radius < 1) {
            radius = 1;
        }
        for (Direction cardinalDirection : Direction.values()) {
            EnumFacing branchDirection = cardinalDirection.facing;
            this.wood.setDirection(branchDirection);
            int offsetX = 0;
            int offsetZ = 0;
            if (branchDirection != null) {
                offsetX = branchDirection.func_82601_c();
                offsetZ = branchDirection.func_82599_e();
            }
            block1: for (int i = 0; i < count; ++i) {
                if (world.field_73012_v.nextFloat() > chance) continue;
                int y = startY;
                int x = xOffset;
                int z = zOffset;
                for (int r = 0; r < radius; ++r) {
                    if (world.field_73012_v.nextFloat() < spreadY) {
                        ++y;
                    } else if (world.field_73012_v.nextFloat() < spreadXZ) {
                        if (offsetX == 0) {
                            x = world.field_73012_v.nextBoolean() ? ++x : --x;
                            this.wood.setDirection(EnumFacing.EAST);
                        } else if (offsetZ == 0) {
                            z = world.field_73012_v.nextBoolean() ? ++z : --z;
                            this.wood.setDirection(EnumFacing.SOUTH);
                        }
                    } else {
                        x += offsetX;
                        z += offsetZ;
                        this.wood.setDirection(branchDirection);
                    }
                    if (!this.addWood(world, new BlockPos(x, y, z), WorldGenBase.EnumReplaceMode.SOFT)) continue block1;
                    branchEnds.add(new BlockPos(x, y, z));
                }
            }
        }
        return branchEnds;
    }

    @Override
    protected boolean addBlock(World world, BlockPos pos, ITreeBlockType type, WorldGenBase.EnumReplaceMode replaceMode) {
        if (!world.func_175667_e(pos = pos.func_177971_a((Vec3i)this.startPos))) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(pos);
        if (replaceMode.canReplace(blockState, world, pos)) {
            type.setBlock(world, this.tree, pos);
            return true;
        }
        return false;
    }

    protected final boolean addWood(World world, BlockPos pos, WorldGenBase.EnumReplaceMode replace) {
        return this.addBlock(world, pos, this.wood, replace);
    }

    protected final boolean addLeaf(World world, BlockPos pos, WorldGenBase.EnumReplaceMode replace) {
        return this.addBlock(world, pos, this.leaf, replace);
    }

    protected final boolean addVine(World world, BlockPos pos, ITreeBlockType vine) {
        return this.addBlock(world, pos, vine, WorldGenBase.EnumReplaceMode.AIR);
    }

    protected final void addVines(World world, BlockPos pos, float chance) {
        if (chance <= 0.0f) {
            return;
        }
        if (world.field_73012_v.nextFloat() < chance) {
            this.addVine(world, pos.func_177982_a(-1, 0, 0), vineWest);
        }
        if (world.field_73012_v.nextFloat() < chance) {
            this.addVine(world, pos.func_177982_a(1, 0, 0), vineEast);
        }
        if (world.field_73012_v.nextFloat() < chance) {
            this.addVine(world, pos.func_177982_a(0, 0, -1), vineNorth);
        }
        if (world.field_73012_v.nextFloat() < chance) {
            this.addVine(world, pos.func_177982_a(0, 0, 1), vineSouth);
        }
    }

    static enum Direction {
        NORTH(EnumFacing.NORTH),
        SOUTH(EnumFacing.SOUTH),
        WEST(EnumFacing.WEST),
        EAST(EnumFacing.EAST);

        public final EnumFacing facing;

        private Direction(EnumFacing forgeDirection) {
            this.facing = forgeDirection;
        }

        public static Direction getRandom(Random random) {
            return Direction.values()[random.nextInt(Direction.values().length)];
        }

        public static Direction getRandomOther(Random random, Direction direction) {
            EnumSet<Direction> directions = EnumSet.allOf(Direction.class);
            directions.remove((Object)direction);
            int size = directions.size();
            return directions.toArray(new Direction[size])[random.nextInt(size)];
        }
    }
}

