/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.worldgen;

import forestry.api.world.ITreeGenData;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.arboriculture.worldgen.WorldGenTree;
import forestry.core.worldgen.WorldGenBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenAcacia
extends WorldGenTree {
    public WorldGenAcacia(ITreeGenData tree) {
        super(tree, 5, 2);
    }

    @Override
    public void generate(World world) {
        WorldGenArboriculture.Direction leanDirection = WorldGenArboriculture.Direction.getRandom(world.field_73012_v);
        float leanAmount = (float)this.height / 4.0f;
        List<BlockPos> treeTops = this.generateTreeTrunk(world, this.height, this.girth, 0.0f, leanDirection.facing, leanAmount);
        if (this.height > 5 && world.field_73012_v.nextBoolean()) {
            WorldGenArboriculture.Direction branchDirection = WorldGenArboriculture.Direction.getRandomOther(world.field_73012_v, leanDirection);
            List<BlockPos> treeTops2 = this.generateTreeTrunk(world, Math.round((float)this.height * 0.66f), this.girth, 0.0f, branchDirection.facing, leanAmount);
            treeTops.addAll(treeTops2);
        }
        ArrayList<BlockPos> branchLocations = new ArrayList<BlockPos>();
        for (BlockPos treeTop : treeTops) {
            int xOffset = treeTop.func_177958_n();
            int yOffset = treeTop.func_177956_o() + 1;
            int zOffset = treeTop.func_177952_p();
            float canopyMultiplier = (1.5f * (float)this.height - (float)yOffset + 2.0f) / 4.0f;
            int canopyThickness = Math.max(1, Math.round((float)yOffset / 10.0f));
            this.generateAdjustedCylinder(world, yOffset--, xOffset, zOffset, canopyMultiplier, 1, this.leaf, WorldGenBase.EnumReplaceMode.AIR);
            float canopyWidth = world.field_73012_v.nextBoolean() ? 3.0f : 2.5f;
            List<BlockPos> branches = this.generateBranches(world, yOffset - canopyThickness, xOffset, zOffset, 0.0f, 0.1f, Math.round(canopyMultiplier * canopyWidth - 4.0f), 2);
            branchLocations.addAll(branches);
        }
        for (BlockPos branchLocation : branchLocations) {
            int leafSpawn = branchLocation.func_177956_o();
            int canopyThickness = Math.max(1, Math.round((float)leafSpawn / 10.0f));
            float canopyMultiplier = (1.5f * (float)this.height - (float)leafSpawn + 2.0f) / 4.0f;
            float canopyWidth = world.field_73012_v.nextBoolean() ? 1.0f : 1.5f;
            this.generateAdjustedCylinder(world, leafSpawn - canopyThickness + 1, branchLocation.func_177958_n(), branchLocation.func_177952_p(), canopyMultiplier * canopyWidth, canopyThickness, this.leaf, WorldGenBase.EnumReplaceMode.AIR);
        }
        if (this.hasPods()) {
            this.generatePods(world, this.height, this.girth);
        }
    }
}

