/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.arboriculture.genetics.Tree;
import forestry.core.access.IOwnable;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IStreamable;
import forestry.core.network.packets.PacketTileStream;
import forestry.core.utils.PlayerUtil;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileTreeContainer
extends TileEntity
implements IStreamable,
IOwnable {
    @Nullable
    private ITree containedTree;
    @Nullable
    private GameProfile owner;

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("ContainedTree")) {
            this.containedTree = new Tree(nbttagcompound.func_74775_l("ContainedTree"));
        }
        if (nbttagcompound.func_74764_b("owner")) {
            this.owner = PlayerUtil.readGameProfileFromNBT(nbttagcompound.func_74775_l("owner"));
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.containedTree != null) {
            NBTTagCompound subcompound = new NBTTagCompound();
            this.containedTree.writeToNBT(subcompound);
            nbttagcompound.func_74782_a("ContainedTree", (NBTBase)subcompound);
        }
        if (this.owner != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            PlayerUtil.writeGameProfile(nbt, this.owner);
            nbttagcompound.func_74782_a("owner", (NBTBase)nbt);
        }
    }

    @Override
    public void writeData(DataOutputStreamForestry data) throws IOException {
        String speciesUID = "";
        ITree tree = this.getTree();
        if (tree != null) {
            speciesUID = tree.getIdent();
        }
        data.writeUTF(speciesUID);
    }

    @Override
    public void readData(DataInputStreamForestry data) throws IOException {
        String speciesUID = data.readUTF();
        ITree tree = TileTreeContainer.getTree(speciesUID);
        this.setTree(tree);
    }

    private static ITree getTree(String speciesUID) {
        IAllele[] treeTemplate = TreeManager.treeRoot.getTemplate(speciesUID);
        if (treeTemplate == null) {
            return null;
        }
        return TreeManager.treeRoot.templateAsIndividual(treeTemplate);
    }

    public void setTree(ITree tree) {
        this.containedTree = tree;
        if (this.field_145850_b != null && this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    @Nullable
    public ITree getTree() {
        return this.containedTree;
    }

    @Override
    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable GameProfile owner) {
        this.owner = owner;
    }

    @Override
    public boolean isOwned() {
        return this.owner != null;
    }

    @Override
    public boolean isOwner(EntityPlayer player) {
        return player != null && PlayerUtil.isSameGameProfile(player.func_146103_bH(), this.owner);
    }

    public abstract void onBlockTick();

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return !Block.func_149680_a((Block)oldState.func_177230_c(), (Block)newSate.func_177230_c());
    }

    public Packet func_145844_m() {
        return new PacketTileStream(this).getPacket();
    }
}

