/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.tiles;

import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.arboriculture.tiles.TileTreeContainer;
import forestry.arboriculture.worldgen.WorldGenArboriculture;
import forestry.core.worldgen.WorldGenBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class TileSapling
extends TileTreeContainer {
    private int timesTicked = 0;

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.timesTicked = nbttagcompound.func_74762_e("TT");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("TT", this.timesTicked);
    }

    @Override
    public void onBlockTick() {
        ++this.timesTicked;
        this.tryGrow(false);
    }

    private static int getRequiredMaturity(World world, ITree tree) {
        ITreekeepingMode treekeepingMode = TreeManager.treeRoot.getTreekeepingMode(world);
        float maturationModifier = treekeepingMode.getMaturationModifier(tree.getGenome(), 1.0f);
        return Math.round((float)tree.getRequiredMaturity() * maturationModifier);
    }

    public boolean canAcceptBoneMeal() {
        ITree tree = this.getTree();
        if (tree == null) {
            return false;
        }
        int maturity = TileSapling.getRequiredMaturity(this.field_145850_b, tree);
        if (this.timesTicked < maturity) {
            return true;
        }
        WorldGenerator generator = tree.getTreeGenerator(this.field_145850_b, this.func_174877_v(), true);
        if (generator instanceof WorldGenArboriculture) {
            WorldGenArboriculture arboricultureGenerator = (WorldGenArboriculture)generator;
            arboricultureGenerator.preGenerate(this.field_145850_b, this.func_174877_v());
            return arboricultureGenerator.canGrow(this.field_145850_b, this.func_174877_v());
        }
        return true;
    }

    public void tryGrow(boolean bonemealed) {
        ITree tree = this.getTree();
        if (tree == null) {
            return;
        }
        int maturity = TileSapling.getRequiredMaturity(this.field_145850_b, tree);
        if (this.timesTicked < maturity) {
            if (bonemealed) {
                this.timesTicked = maturity;
            }
            return;
        }
        WorldGenerator generator = tree.getTreeGenerator(this.field_145850_b, this.func_174877_v(), bonemealed);
        boolean generated = generator instanceof WorldGenBase ? ((WorldGenBase)generator).generate(this.field_145850_b, this.func_174877_v(), bonemealed) : generator.func_180709_b(this.field_145850_b, this.field_145850_b.field_73012_v, this.func_174877_v());
        if (generated) {
            IArboristTracker breedingTracker = TreeManager.treeRoot.getBreedingTracker(this.field_145850_b, this.getOwner());
            breedingTracker.registerBirth(tree);
        }
    }
}

