/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.items;

import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.IModelManager;
import forestry.api.core.Tabs;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.ICheckPollinatable;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IPollinatable;
import forestry.api.recipes.IVariableFermentable;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.core.config.Config;
import forestry.core.genetics.ItemGE;
import forestry.core.items.IColoredItem;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.proxy.Proxies;
import forestry.core.utils.GeneticsUtil;
import forestry.core.utils.Translator;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemGermlingGE
extends ItemGE
implements IVariableFermentable,
IColoredItem {
    private final EnumGermlingType type;

    public ItemGermlingGE(EnumGermlingType type) {
        super(Tabs.tabArboriculture);
        this.type = type;
    }

    @Override
    public ITree getIndividual(ItemStack itemstack) {
        return new Tree(itemstack.func_77978_p());
    }

    @Override
    protected IAlleleTreeSpecies getSpecies(ItemStack itemStack) {
        return TreeGenome.getSpecies(itemStack);
    }

    private static IAlleleTreeSpecies getSpeciesOrDefault(ItemStack itemstack) {
        IAlleleTreeSpecies treeSpecies = TreeGenome.getSpecies(itemstack);
        if (treeSpecies == null) {
            treeSpecies = TreeDefinition.Oak.getGenome().getPrimary();
        }
        return treeSpecies;
    }

    public String func_77653_i(ItemStack itemstack) {
        if (!itemstack.func_77942_o()) {
            return "Unknown";
        }
        IAlleleTreeSpecies species = this.getSpecies(itemstack);
        String customTreeKey = "for.trees.custom." + this.type.getName() + "." + species.getUnlocalizedName().replace("trees.species.", "");
        if (Translator.canTranslateToLocal(customTreeKey)) {
            return Translator.translateToLocal(customTreeKey);
        }
        String typeString = Translator.translateToLocal("for.trees.grammar." + this.type.getName() + ".type");
        return Translator.translateToLocal("for.trees.grammar." + this.type.getName()).replaceAll("%SPECIES", species.getName()).replaceAll("%TYPE", typeString);
    }

    public void func_150895_a(Item item, CreativeTabs par2CreativeTabs, List<ItemStack> itemList) {
        this.addCreativeItems(itemList, true);
    }

    public void addCreativeItems(List<ItemStack> itemList, boolean hideSecrets) {
        for (IIndividual iIndividual : TreeManager.treeRoot.getIndividualTemplates()) {
            if (hideSecrets && iIndividual.isSecret() && !Config.isDebug) continue;
            itemList.add(TreeManager.treeRoot.getMemberStack(iIndividual, this.type));
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(ItemStack itemstack, int renderPass) {
        return ItemGermlingGE.getSpeciesOrDefault(itemstack).getGermlingColour(this.type, renderPass);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        manager.registerItemModel(item, new GermlingMeshDefinition());
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleTreeSpecies)) continue;
            ((IAlleleTreeSpecies)allele).registerModels(item, manager);
        }
    }

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ITree tree = TreeManager.treeRoot.getMember(stack);
        if (tree == null) {
            return EnumActionResult.PASS;
        }
        if (this.type == EnumGermlingType.SAPLING) {
            IBlockState hitBlock = worldIn.func_180495_p(pos);
            if (!hitBlock.func_177230_c().func_176200_f((IBlockAccess)worldIn, pos)) {
                if (!worldIn.func_175623_d(pos.func_177984_a())) {
                    return EnumActionResult.FAIL;
                }
                pos = pos.func_177984_a();
            }
            if (!tree.canStay((IBlockAccess)worldIn, pos)) {
                return EnumActionResult.FAIL;
            }
            if (TreeManager.treeRoot.plantSapling(worldIn, tree, playerIn.func_146103_bH(), pos)) {
                Proxies.common.addBlockPlaceEffects(worldIn, pos, worldIn.func_180495_p(pos));
                if (!playerIn.field_71075_bZ.field_75098_d) {
                    --stack.field_77994_a;
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.FAIL;
        }
        if (this.type == EnumGermlingType.POLLEN) {
            ICheckPollinatable checkPollinatable = GeneticsUtil.getCheckPollinatable(worldIn, pos);
            if (checkPollinatable == null) {
                return EnumActionResult.PASS;
            }
            if (!checkPollinatable.canMateWith(tree)) {
                return EnumActionResult.FAIL;
            }
            IPollinatable pollinatable = GeneticsUtil.getOrCreatePollinatable(playerIn.func_146103_bH(), worldIn, pos);
            if (!pollinatable.canMateWith(tree)) {
                return EnumActionResult.FAIL;
            }
            pollinatable.mateWith(tree);
            Proxies.common.sendFXSignal(PacketFXSignal.VisualFXType.BLOCK_DESTROY, PacketFXSignal.SoundFXType.LEAF, worldIn, pos, worldIn.func_180495_p(pos));
            if (!playerIn.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public float getFermentationModifier(ItemStack itemstack) {
        ITree tree = TreeManager.treeRoot.getMember(itemstack);
        if (tree == null) {
            return 1.0f;
        }
        return tree.getGenome().getSappiness() * 10.0f;
    }

    @SideOnly(value=Side.CLIENT)
    private class GermlingMeshDefinition
    implements ItemMeshDefinition {
        private GermlingMeshDefinition() {
        }

        public ModelResourceLocation func_178113_a(ItemStack stack) {
            IAlleleTreeSpecies treeSpecies = ItemGermlingGE.this.getSpecies(stack);
            if (treeSpecies == null) {
                treeSpecies = TreeDefinition.Oak.getGenome().getPrimary();
            }
            return treeSpecies.getGermlingModel(ItemGermlingGE.this.type);
        }
    }
}

