/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import com.mojang.authlib.GameProfile;
import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.EnumTreeChromosome;
import forestry.api.arboriculture.IAlleleLeafEffect;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.IArboristTracker;
import forestry.api.arboriculture.IFruitProvider;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.arboriculture.ITreeMutation;
import forestry.api.arboriculture.TreeManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleBoolean;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IFruitFamily;
import forestry.api.genetics.IMutation;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeGenome;
import forestry.arboriculture.genetics.alleles.AlleleFruit;
import forestry.core.config.Config;
import forestry.core.genetics.Chromosome;
import forestry.core.genetics.Individual;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class Tree
extends Individual
implements ITree,
IPlantable {
    @Nonnull
    private final ITreeGenome genome;
    @Nullable
    private ITreeGenome mate;
    private final EnumSet<EnumPlantType> plantTypes;
    private EnumPlantType plantType;

    public Tree(@Nonnull ITreeGenome genome) {
        this.genome = genome;
        this.plantTypes = genome.getPlantTypes();
        this.plantTypes.add(genome.getPrimary().getPlantType());
    }

    public Tree(@Nonnull NBTTagCompound nbttagcompound) {
        super(nbttagcompound);
        this.genome = nbttagcompound.func_74764_b("Genome") ? new TreeGenome(nbttagcompound.func_74775_l("Genome")) : TreeDefinition.Oak.getGenome();
        this.plantTypes = this.genome.getPlantTypes();
        this.plantTypes.add(this.genome.getPrimary().getPlantType());
        if (nbttagcompound.func_74764_b("Mate")) {
            this.mate = new TreeGenome(nbttagcompound.func_74775_l("Mate"));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagCompound nbtGenome = new NBTTagCompound();
        this.genome.writeToNBT(nbtGenome);
        nbttagcompound.func_74782_a("Genome", (NBTBase)nbtGenome);
        if (this.mate != null) {
            NBTTagCompound nbtMate = new NBTTagCompound();
            this.mate.writeToNBT(nbtMate);
            nbttagcompound.func_74782_a("Mate", (NBTBase)nbtMate);
        }
    }

    @Override
    public void mate(ITree other) {
        this.mate = new TreeGenome(other.getGenome().getChromosomes());
    }

    @Override
    public IEffectData[] doEffect(IEffectData[] storedData, World world, BlockPos pos) {
        IAlleleLeafEffect effect = (IAlleleLeafEffect)this.getGenome().getActiveAllele(EnumTreeChromosome.EFFECT);
        if (effect == null) {
            return null;
        }
        storedData[0] = this.doEffect(effect, storedData[0], world, pos);
        if (!effect.isCombinable()) {
            return storedData;
        }
        IAlleleLeafEffect secondary = (IAlleleLeafEffect)this.getGenome().getInactiveAllele(EnumTreeChromosome.EFFECT);
        if (!secondary.isCombinable()) {
            return storedData;
        }
        storedData[1] = this.doEffect(secondary, storedData[1], world, pos);
        return storedData;
    }

    private IEffectData doEffect(IAlleleLeafEffect effect, IEffectData storedData, World world, BlockPos pos) {
        storedData = effect.validateStorage(storedData);
        return effect.doEffect(this.getGenome(), storedData, world, pos);
    }

    @Override
    public IEffectData[] doFX(IEffectData[] storedData, World world, BlockPos pos) {
        return null;
    }

    @Override
    public WorldGenerator getTreeGenerator(World world, BlockPos pos, boolean wasBonemealed) {
        return this.genome.getPrimary().getGenerator().getWorldGenerator(this);
    }

    @Override
    public boolean canStay(IBlockAccess world, BlockPos pos) {
        BlockPos blockPos = pos.func_177977_b();
        IBlockState blockState = world.func_180495_p(blockPos);
        if (blockState == null) {
            return false;
        }
        Block block = blockState.func_177230_c();
        Iterator iterator = this.getPlantTypes().iterator();
        while (iterator.hasNext()) {
            EnumPlantType type;
            this.plantType = type = (EnumPlantType)iterator.next();
            if (!block.canSustainPlant(blockState, world, blockPos, EnumFacing.UP, (IPlantable)this)) continue;
            return true;
        }
        return false;
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        return this.plantType;
    }

    public IBlockState getPlant(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos);
    }

    @Override
    public boolean canGrow(World world, BlockPos pos, int expectedGirth, int expectedHeight) {
        IGrowthProvider growthProvider = this.genome.getGrowthProvider();
        return growthProvider.canGrow(this.genome, world, pos, expectedGirth, expectedHeight);
    }

    @Override
    public int getRequiredMaturity() {
        return this.genome.getMaturationTime();
    }

    @Override
    public EnumGrowthConditions getGrowthCondition(World world, BlockPos pos) {
        return this.genome.getGrowthProvider().getGrowthConditions(this.getGenome(), world, pos);
    }

    @Override
    public int getGirth(World world, BlockPos pos) {
        return this.genome.getGirth();
    }

    @Override
    public int getResilience() {
        int base = (int)(this.getGenome().getFertility() * this.getGenome().getSappiness() * 100.0f);
        return (base > 1 ? base : 1) * 10;
    }

    @Override
    public float getHeightModifier() {
        return this.genome.getHeight();
    }

    @Override
    public boolean setLeaves(World world, GameProfile owner, BlockPos pos) {
        return this.genome.getPrimary().getGenerator().setLeaves(this.genome, world, owner, pos);
    }

    @Override
    public boolean setLogBlock(World world, BlockPos pos, EnumFacing facing) {
        return this.genome.getPrimary().getGenerator().setLogBlock(this.genome, world, pos, facing);
    }

    @Override
    public boolean allowsFruitBlocks() {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        if (!provider.requiresFruitBlocks()) {
            return false;
        }
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        return suitable.contains(provider.getFamily());
    }

    @Override
    public boolean trySpawnFruitBlock(World world, BlockPos pos) {
        IFruitProvider provider = this.getGenome().getFruitProvider();
        Collection<IFruitFamily> suitable = this.genome.getPrimary().getSuitableFruit();
        if (!suitable.contains(provider.getFamily())) {
            return false;
        }
        return provider.trySpawnFruitBlock(this.getGenome(), world, pos);
    }

    @Override
    @Nonnull
    public ITreeGenome getGenome() {
        return this.genome;
    }

    @Override
    public ITree copy() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.writeToNBT(nbttagcompound);
        return new Tree(nbttagcompound);
    }

    @Override
    @Nullable
    public ITreeGenome getMate() {
        return this.mate;
    }

    @Override
    public boolean isPureBred(EnumTreeChromosome chromosome) {
        return this.genome.getActiveAllele(chromosome).getUID().equals(this.genome.getInactiveAllele(chromosome).getUID());
    }

    @Override
    public EnumSet<EnumPlantType> getPlantTypes() {
        return this.plantTypes;
    }

    @Override
    public void addTooltip(List<String> list) {
        IAllele fruit;
        if (!this.isAnalyzed) {
            list.add("<" + Translator.translateToLocal("for.gui.unknown") + ">");
            return;
        }
        IAlleleTreeSpecies primary = this.genome.getPrimary();
        IAlleleTreeSpecies secondary = this.genome.getSecondary();
        if (!this.isPureBred(EnumTreeChromosome.SPECIES)) {
            list.add(TextFormatting.BLUE + Translator.translateToLocal("for.trees.hybrid").replaceAll("%PRIMARY", primary.getName()).replaceAll("%SECONDARY", secondary.getName()));
        }
        String sappiness = TextFormatting.GOLD + "S: " + this.genome.getActiveAllele(EnumTreeChromosome.SAPPINESS).getName();
        String maturation = TextFormatting.RED + "M: " + this.genome.getActiveAllele(EnumTreeChromosome.MATURATION).getName();
        String height = TextFormatting.LIGHT_PURPLE + "H: " + this.genome.getActiveAllele(EnumTreeChromosome.HEIGHT).getName();
        String girth = TextFormatting.AQUA + "G: " + String.format("%sx%s", this.genome.getGirth(), this.genome.getGirth());
        String saplings = TextFormatting.YELLOW + "S: " + this.genome.getActiveAllele(EnumTreeChromosome.FERTILITY).getName();
        String yield = TextFormatting.WHITE + "Y: " + this.genome.getActiveAllele(EnumTreeChromosome.YIELD).getName();
        list.add(String.format("%s, %s", saplings, maturation));
        list.add(String.format("%s, %s", height, girth));
        list.add(String.format("%s, %s", yield, sappiness));
        IAlleleBoolean primaryFireproof = (IAlleleBoolean)this.genome.getActiveAllele(EnumTreeChromosome.FIREPROOF);
        if (primaryFireproof.getValue()) {
            list.add(TextFormatting.RED + Translator.translateToLocal("for.gui.fireresist"));
        }
        if ((fruit = this.getGenome().getActiveAllele(EnumTreeChromosome.FRUITS)) != AlleleFruit.fruitNone) {
            String strike = "";
            if (!this.canBearFruit()) {
                strike = TextFormatting.STRIKETHROUGH.toString();
            }
            list.add(strike + TextFormatting.GREEN + "F: " + this.genome.getFruitProvider().getDescription());
        }
    }

    @Override
    public ITree[] getSaplings(World world, GameProfile playerProfile, BlockPos pos, float modifier) {
        ArrayList<ITree> prod = new ArrayList<ITree>();
        float chance = this.genome.getFertility() * modifier;
        if (world.field_73012_v.nextFloat() <= chance) {
            if (this.getMate() == null) {
                prod.add(TreeManager.treeRoot.getTree(world, new TreeGenome(this.genome.getChromosomes())));
            } else {
                prod.add(this.createOffspring(world, playerProfile, pos));
            }
        }
        return prod.toArray(new ITree[prod.size()]);
    }

    private ITree createOffspring(World world, GameProfile playerProfile, BlockPos pos) {
        IChromosome[] chromosomes = new IChromosome[this.genome.getChromosomes().length];
        IChromosome[] parent1 = this.genome.getChromosomes();
        IChromosome[] parent2 = this.mate.getChromosomes();
        IChromosome[] mutated = Tree.mutateSpecies(world, playerProfile, pos, this.genome, this.mate);
        if (mutated == null) {
            mutated = Tree.mutateSpecies(world, playerProfile, pos, this.mate, this.genome);
        }
        if (mutated != null) {
            return new Tree(new TreeGenome(mutated));
        }
        for (int i = 0; i < parent1.length; ++i) {
            if (parent1[i] == null || parent2[i] == null) continue;
            chromosomes[i] = Chromosome.inheritChromosome(world.field_73012_v, parent1[i], parent2[i]);
        }
        return new Tree(new TreeGenome(chromosomes));
    }

    private static IChromosome[] mutateSpecies(World world, @Nullable GameProfile playerProfile, BlockPos pos, ITreeGenome genomeOne, ITreeGenome genomeTwo) {
        ITreeGenome genome1;
        ITreeGenome genome0;
        IAlleleTreeSpecies allele1;
        IAlleleTreeSpecies allele0;
        IChromosome[] parent1 = genomeOne.getChromosomes();
        IChromosome[] parent2 = genomeTwo.getChromosomes();
        if (world.field_73012_v.nextBoolean()) {
            allele0 = (IAlleleTreeSpecies)parent1[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleTreeSpecies)parent2[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeOne;
            genome1 = genomeTwo;
        } else {
            allele0 = (IAlleleTreeSpecies)parent2[EnumTreeChromosome.SPECIES.ordinal()].getPrimaryAllele();
            allele1 = (IAlleleTreeSpecies)parent1[EnumTreeChromosome.SPECIES.ordinal()].getSecondaryAllele();
            genome0 = genomeTwo;
            genome1 = genomeOne;
        }
        IArboristTracker breedingTracker = null;
        if (playerProfile != null) {
            breedingTracker = TreeManager.treeRoot.getBreedingTracker(world, playerProfile);
        }
        List<IMutation> combinations = TreeManager.treeRoot.getCombinations(allele0, allele1, true);
        for (IMutation mutation : combinations) {
            ITreeMutation treeMutation = (ITreeMutation)mutation;
            float chance = treeMutation.getChance(world, pos, allele0, allele1, genome0, genome1);
            if (chance <= 0.0f) continue;
            if (breedingTracker != null && breedingTracker.isResearched(treeMutation)) {
                float mutationBoost = chance * (Config.researchMutationBoostMultiplier - 1.0f);
                mutationBoost = Math.min(Config.maxResearchMutationBoostPercent, mutationBoost);
                chance += mutationBoost;
            }
            if (!(chance > world.field_73012_v.nextFloat() * 100.0f)) continue;
            return TreeManager.treeRoot.templateAsChromosomes(treeMutation.getTemplate());
        }
        return null;
    }

    @Override
    public boolean canBearFruit() {
        return this.genome.getPrimary().getSuitableFruit().contains(this.genome.getFruitProvider().getFamily());
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getProducts() {
        return this.genome.getFruitProvider().getProducts();
    }

    @Override
    @Nonnull
    public Map<ItemStack, Float> getSpecialties() {
        return this.genome.getFruitProvider().getSpecialty();
    }

    @Override
    @Nonnull
    public List<ItemStack> produceStacks(World world, BlockPos pos, int ripeningTime) {
        return this.genome.getFruitProvider().getFruits(this.genome, world, pos, ripeningTime);
    }
}

