/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.EnumGrowthConditions;
import forestry.api.arboriculture.IGrowthProvider;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.ForestryAPI;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.utils.Translator;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class GrowthProvider
implements IGrowthProvider {
    @Override
    public boolean canGrow(ITreeGenome genome, World world, BlockPos pos, int expectedGirth, int expectedHeight) {
        if (!GrowthProvider.hasRoom(world, pos, expectedGirth, expectedHeight)) {
            return false;
        }
        if (this.getGrowthConditions(genome, world, pos) == EnumGrowthConditions.HOSTILE) {
            return false;
        }
        return GrowthProvider.hasSufficientSaplings(genome, world, pos, expectedGirth);
    }

    @Override
    public EnumGrowthConditions getGrowthConditions(ITreeGenome genome, World world, BlockPos pos) {
        return GrowthProvider.getConditionFromLight(world, pos);
    }

    @Override
    public String getDescription() {
        return Translator.translateToLocal("for.growth.normal");
    }

    @Override
    public String[] getInfo() {
        return new String[0];
    }

    protected static EnumGrowthConditions getConditionsFromRainfall(World world, BlockPos pos, float min, float max) {
        float humidity = ForestryAPI.climateManager.getHumidity(world, pos);
        if (humidity < min || humidity > max) {
            return EnumGrowthConditions.HOSTILE;
        }
        return EnumGrowthConditions.EXCELLENT;
    }

    protected static EnumGrowthConditions getConditionsFromTemperature(World world, BlockPos pos, float min, float max) {
        float biomeTemperature = ForestryAPI.climateManager.getTemperature(world, pos);
        if (biomeTemperature < min || biomeTemperature > max) {
            return EnumGrowthConditions.HOSTILE;
        }
        return EnumGrowthConditions.EXCELLENT;
    }

    protected static EnumGrowthConditions getConditionFromLight(World world, BlockPos pos) {
        int lightvalue = world.func_175671_l(pos.func_177982_a(0, 1, 0));
        if (lightvalue > 13) {
            return EnumGrowthConditions.EXCELLENT;
        }
        if (lightvalue > 11) {
            return EnumGrowthConditions.GOOD;
        }
        if (lightvalue > 8) {
            return EnumGrowthConditions.NORMAL;
        }
        if (lightvalue > 6) {
            return EnumGrowthConditions.PALTRY;
        }
        return EnumGrowthConditions.HOSTILE;
    }

    private static boolean hasRoom(World world, BlockPos pos, int expectedGirth, int expectedHeight) {
        int offset = (expectedGirth - 1) / 2;
        BlockPos start = new BlockPos(pos.func_177958_n() - offset, pos.func_177956_o() + 1, pos.func_177952_p() + offset);
        Vec3i area = new Vec3i(-offset + expectedGirth, expectedHeight + 1, -offset + expectedGirth);
        return GrowthProvider.checkArea(world, start, area);
    }

    private static boolean checkArea(World world, BlockPos start, Vec3i area) {
        for (int x = start.func_177958_n(); x < start.func_177958_n() + area.func_177958_n(); ++x) {
            for (int y = start.func_177956_o(); y < start.func_177956_o() + area.func_177956_o(); ++y) {
                for (int z = start.func_177952_p(); z < start.func_177952_p() + area.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    IBlockState blockState = world.func_180495_p(pos);
                    if (blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean hasSufficientSaplings(ITreeGenome genome, World world, BlockPos pos, int expectedGirth) {
        if (expectedGirth == 1) {
            return true;
        }
        int offset = (expectedGirth - 1) / 2;
        for (int x = pos.func_177958_n() - offset; x < pos.func_177958_n() - offset + expectedGirth; ++x) {
            for (int z = pos.func_177952_p() - offset; z < pos.func_177952_p() - offset + expectedGirth; ++z) {
                BlockPos newPos = new BlockPos(x, pos.func_177956_o(), z);
                if (world.func_175623_d(newPos)) {
                    return false;
                }
                TileEntity tile = world.func_175625_s(newPos);
                if (!(tile instanceof TileSapling)) {
                    return false;
                }
                ITree tree = ((TileSapling)tile).getTree();
                if (tree != null && tree.getGenome().getPrimary().getUID().equals(genome.getPrimary().getUID())) continue;
                return false;
            }
        }
        return true;
    }
}

